/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.spot.server;

import com.google.common.collect.Maps;
import com.samskivert.util.HashIntMap;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.chat.server.SpeakUtil;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.server.InvocationException;
import com.threerings.util.Name;
import com.threerings.whirled.server.SceneManager;
import com.threerings.whirled.spot.Log;
import com.threerings.whirled.spot.data.Cluster;
import com.threerings.whirled.spot.data.ClusterObject;
import com.threerings.whirled.spot.data.ClusteredBodyObject;
import com.threerings.whirled.spot.data.Location;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SceneLocation;
import com.threerings.whirled.spot.data.SpotCodes;
import com.threerings.whirled.spot.data.SpotScene;
import com.threerings.whirled.spot.data.SpotSceneObject;
import java.util.HashMap;
import java.util.Iterator;

public class SpotSceneManager
extends SceneManager
implements SpotCodes {
    protected SpotSceneObject _ssobj;
    protected SpotScene _sscene;
    protected HashIntMap<ClusterRecord> _clusters = new HashIntMap();
    protected HashMap<Integer, Portal> _enterers = Maps.newHashMap();

    public static void moveBodyToDefaultPortal(PlaceRegistry plreg, BodyObject body) {
        SpotSceneManager mgr = (SpotSceneManager)plreg.getPlaceManager(body.getPlaceOid());
        if (mgr != null) {
            mgr.moveToDefaultPortal(body);
        }
    }

    public void mapEnteringBody(BodyObject body, Portal from) {
        if (from != null) {
            this._enterers.put(body.getOid(), from);
        }
    }

    public void clearEnteringBody(BodyObject body) {
        this._enterers.remove(body.getOid());
    }

    public String mayTraversePortal(BodyObject body, Portal portal) {
        return null;
    }

    public void willTraversePortal(BodyObject body, Portal portal) {
        this.updateLocation(body, portal.getLocation());
    }

    protected void didStartup() {
        this._ssobj = (SpotSceneObject)this._plobj;
        super.didStartup();
    }

    protected void gotSceneData(Object extras) {
        super.gotSceneData(extras);
        this._sscene = (SpotScene)((Object)this._scene);
    }

    protected void bodyLeft(int bodyOid) {
        super.bodyLeft(bodyOid);
        this._ssobj.removeFromOccupantLocs(Integer.valueOf(bodyOid));
        this.removeFromCluster(bodyOid);
        Iterator cliter = this._clusters.values().iterator();
        while (cliter.hasNext()) {
            ClusterRecord clrec = (ClusterRecord)((Object)cliter.next());
            if (!clrec.containsKey(bodyOid)) continue;
            Log.log.info((Object)"Pruning departed body from cluster", new Object[]{"boid", bodyOid, "cluster", clrec});
            clrec.removeBody(bodyOid);
            if (clrec.size() != 0) continue;
            clrec.destroy(false);
            cliter.remove();
        }
    }

    protected void addOccupantInfo(BodyObject body, OccupantInfo info) {
        this.assignStartingLocation(body);
        super.addOccupantInfo(body, info);
    }

    protected void assignStartingLocation(BodyObject body) {
        Portal entry;
        Portal from = this._enterers.remove(body.getOid());
        if (from != null && from.targetPortalId != -1) {
            entry = this._sscene.getPortal(from.targetPortalId);
            if (entry == null) {
                Log.log.warning((Object)"Body mapped at invalid portal", new Object[]{"where", this.where(), "who", body.who(), "from", from});
                entry = this._sscene.getDefaultEntrance();
            }
        } else {
            entry = this._sscene.getDefaultEntrance();
        }
        this._ssobj.addToOccupantLocs(this.computeEnteringLocation(body, from, entry));
    }

    protected SceneLocation computeEnteringLocation(BodyObject body, Portal from, Portal entry) {
        return new SceneLocation(entry.getOppLocation(), body.getOid());
    }

    protected void moveToDefaultPortal(BodyObject body) {
        SpotScene scene = (SpotScene)((Object)this.getScene());
        if (scene == null) {
            Log.log.warning((Object)"No scene in moveBodyToDefaultPortal()?", new Object[]{"who", body.who(), "where", this.where()});
            return;
        }
        try {
            Location eloc = scene.getDefaultEntrance().getLocation();
            this.handleChangeLoc(body, eloc);
        }
        catch (InvocationException ie) {
            Log.log.warning((Object)"Could not move user to default portal", new Object[]{"where", this.where(), "who", body.who(), "error", ie});
        }
    }

    protected void handleChangeLoc(BodyObject source, Location loc) throws InvocationException {
        if (!this._ssobj.occupants.contains(source.getOid())) {
            Log.log.warning((Object)"Refusing change loc from non-scene occupant", new Object[]{"where", this.where(), "who", source.who(), "loc", loc});
            throw new InvocationException("m.internal_error");
        }
        if (!this.validateLocation(source, loc)) {
            throw new InvocationException("m.invalid_location");
        }
        this.updateLocation(source, loc);
        this.removeFromCluster(source.getOid());
    }

    protected boolean validateLocation(BodyObject source, Location loc) {
        return true;
    }

    protected void updateLocation(BodyObject source, Location loc) {
        SceneLocation sloc = new SceneLocation(loc, source.getOid());
        if (!this._ssobj.occupantLocs.contains((DSet.Entry)sloc)) {
            Log.log.warning((Object)"Changing loc for occupant without previous loc", new Object[]{"where", this.where(), "who", source.who(), "nloc", loc, new Exception()});
            this._ssobj.addToOccupantLocs(sloc);
        } else {
            this._ssobj.updateOccupantLocs(sloc);
        }
    }

    protected void handleJoinCluster(BodyObject joiner, int targetOid) throws InvocationException {
        ClusterRecord clrec = (ClusterRecord)((Object)this._clusters.get(targetOid));
        if (clrec != null) {
            clrec.addBody(joiner);
            return;
        }
        DObject tobj = this._omgr.getObject(targetOid);
        if (!(tobj instanceof BodyObject)) {
            Log.log.info((Object)"Can't join cluster, missing target", new Object[]{"creator", joiner.who(), "targetOid", targetOid});
            throw new InvocationException("m.no_such_cluster");
        }
        BodyObject friend = (BodyObject)tobj;
        if (friend.getPlaceOid() != joiner.getPlaceOid()) {
            Log.log.info((Object)"Refusing cluster join from non-proximate user", new Object[]{"joiner", joiner.who(), "jloc", joiner.location, "target", friend.who(), "tloc", friend.location});
            throw new InvocationException("m.no_such_cluster");
        }
        clrec = this.getCluster(friend.getOid());
        if (clrec != null) {
            clrec.addBody(joiner);
            return;
        }
        this.checkCanCluster(joiner, friend);
        clrec = this.createClusterRecord();
        clrec.addBody(friend);
        clrec.addBody(joiner);
    }

    protected ClusterRecord createClusterRecord() {
        return new ClusterRecord();
    }

    protected void checkCanCluster(BodyObject initiator, BodyObject target) throws InvocationException {
    }

    protected void removeFromCluster(int bodyOid) {
        ClusterRecord clrec = this.getCluster(bodyOid);
        if (clrec != null) {
            clrec.removeBody(bodyOid);
            if (clrec.size() == 0) {
                clrec.destroy(true);
            }
        }
    }

    protected ClusterRecord getCluster(int bodyOid) {
        BodyObject bobj = (BodyObject)this._omgr.getObject(bodyOid);
        if (bobj instanceof ClusteredBodyObject) {
            return (ClusterRecord)((Object)this._clusters.get(((ClusteredBodyObject)bobj).getClusterOid()));
        }
        return null;
    }

    @Deprecated
    protected void handleClusterSpeakRequest(int sourceOid, Name source, String bundle, String message, byte mode) {
        this.handleClusterMessageRequest(sourceOid, new UserMessage(source, bundle, message, mode));
    }

    protected void handleClusterMessageRequest(int sourceOid, UserMessage message) {
        ClusterRecord clrec = this.getCluster(sourceOid);
        if (clrec == null) {
            Log.log.warning((Object)"Non-clustered user requested cluster speak", new Object[]{"where", this.where(), "chatter", message.speaker + " (" + sourceOid + ")", "msg", message});
        } else {
            SpeakUtil.sendMessage((DObject)clrec.getClusterObject(), (ChatMessage)message);
        }
    }

    protected SceneLocation locationForBody(int bodyOid) {
        return (SceneLocation)this._ssobj.occupantLocs.get((Comparable)Integer.valueOf(bodyOid));
    }

    protected boolean canAddBody(ClusterRecord clrec, BodyObject body) {
        return true;
    }

    protected void bodyAdded(ClusterRecord clrec, BodyObject body) {
    }

    protected void bodyRemoved(ClusterRecord clrec, BodyObject body) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClusterRecord
    extends HashIntMap<ClusteredBodyObject> {
        protected ClusterObject _clobj;
        protected Cluster _cluster = new Cluster();

        public ClusterRecord() {
            this._clobj = (ClusterObject)SpotSceneManager.this._omgr.registerObject((DObject)new ClusterObject());
            SpotSceneManager.this._clusters.put(this._clobj.getOid(), (Object)this);
            for (ClusteredBodyObject body : this.values()) {
                body.setClusterOid(this._clobj.getOid());
                this._clobj.addToOccupants(((BodyObject)body).getOid());
            }
            this._cluster.clusterOid = this._clobj.getOid();
            SpotSceneManager.this._ssobj.addToClusters(this._cluster);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addBody(BodyObject body) throws InvocationException {
            if (!(body instanceof ClusteredBodyObject)) {
                Log.log.warning((Object)"Refusing to add non-clustered body to cluster", new Object[]{"cloid", this._clobj.getOid(), "size", this.size(), "who", body.who()});
                throw new InvocationException("m.internal_error");
            }
            if (this.containsKey(body.getOid())) {
                return false;
            }
            if (!SpotSceneManager.this.canAddBody(this, body)) {
                throw new InvocationException("m.cluster_full");
            }
            SpotSceneManager.this.removeFromCluster(body.getOid());
            this.put(body.getOid(), (ClusteredBodyObject)body);
            SpotSceneManager.this._ssobj.startTransaction();
            try {
                body.startTransaction();
                try {
                    SpotSceneManager.this.bodyAdded(this, body);
                    if (this._clobj != null) {
                        ((ClusteredBodyObject)body).setClusterOid(this._clobj.getOid());
                        this._clobj.addToOccupants(body.getOid());
                        SpotSceneManager.this._ssobj.updateClusters(this._cluster);
                    }
                }
                finally {
                    body.commitTransaction();
                }
            }
            finally {
                SpotSceneManager.this._ssobj.commitTransaction();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeBody(int bodyOid) {
            BodyObject body = (BodyObject)this.remove(bodyOid);
            if (body == null) {
                Log.log.warning((Object)"Requested to remove unknown body from cluster", new Object[]{"cloid", this._clobj.getOid(), "size", this.size(), "who", bodyOid});
                return;
            }
            if (body.isActive()) {
                body.startTransaction();
            }
            try {
                SpotSceneManager.this._ssobj.startTransaction();
                try {
                    ((ClusteredBodyObject)body).setClusterOid(-1);
                    SpotSceneManager.this.bodyRemoved(this, body);
                    if (this._clobj != null) {
                        this._clobj.removeFromOccupants(bodyOid);
                        SpotSceneManager.this._ssobj.updateClusters(this._cluster);
                    }
                }
                finally {
                    SpotSceneManager.this._ssobj.commitTransaction();
                }
            }
            finally {
                if (body.isActive()) {
                    body.commitTransaction();
                }
            }
        }

        public ClusterObject getClusterObject() {
            return this._clobj;
        }

        public Cluster getCluster() {
            return this._cluster;
        }

        public String toString() {
            return "[cluster=" + this._cluster + ", size=" + this.size() + "]";
        }

        protected void destroy(boolean doRemoval) {
            SpotSceneManager.this._ssobj.removeFromClusters(this._cluster.getKey());
            if (doRemoval) {
                SpotSceneManager.this._clusters.remove(this._clobj.getOid());
            }
            SpotSceneManager.this._omgr.destroyObject(this._clobj.getOid());
        }
    }
}

