/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.data;

import com.threerings.crowd.data.PlaceConfig;
import com.threerings.whirled.Log;
import com.threerings.whirled.data.Scene;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.data.SceneUpdate;

public class SceneImpl
implements Scene {
    protected SceneModel _model;
    protected PlaceConfig _config;

    public SceneImpl(SceneModel model, PlaceConfig config) {
        this._model = model;
        this._config = config;
    }

    public SceneImpl() {
        this._model = SceneModel.blankSceneModel();
    }

    public int getId() {
        return this._model.sceneId;
    }

    public String getName() {
        return this._model.name;
    }

    public int getVersion() {
        return this._model.version;
    }

    public PlaceConfig getPlaceConfig() {
        return this._config;
    }

    public void setId(int sceneId) {
        this._model.sceneId = sceneId;
    }

    public void setName(String name) {
        this._model.name = name;
    }

    public void setVersion(int version) {
        this._model.version = version;
    }

    public void updateReceived(SceneUpdate update) {
        try {
            update.validate(this._model);
            update.apply(this._model);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Error applying update [scene=" + this + ", update=" + update + "]."), new Object[]{e});
        }
    }

    public SceneModel getSceneModel() {
        return this._model;
    }

    public String toString() {
        return "[model=" + this._model + ", config=" + this._config + "]";
    }
}

