/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stats.data;

import com.samskivert.util.ArrayUtil;
import com.threerings.stats.data.Stat;

public abstract class StringMapStat
extends Stat {
    protected String[] _keys = new String[0];
    protected int[] _values = new int[0];

    public boolean containsKey(String key) {
        return key == null ? false : ArrayUtil.binarySearch((Object[])this._keys, (int)0, (int)this._keys.length, (Comparable)((Object)key)) >= 0;
    }

    public int get(String key) {
        if (key == null) {
            return 0;
        }
        int iidx = ArrayUtil.binarySearch((Object[])this._keys, (int)0, (int)this._keys.length, (Comparable)((Object)key));
        return iidx < 0 ? 0 : this._values[iidx];
    }

    public boolean put(String key, int value) {
        if (key == null) {
            return false;
        }
        int iidx = this.getOrCreateEntry(key);
        int ovalue = this._values[iidx];
        this._values[iidx] = Math.min(value, this.getMaxValue());
        if (this._values[iidx] != ovalue) {
            this.setModified(true);
            return true;
        }
        return false;
    }

    public boolean increment(String key, int amount) {
        if (key == null) {
            return false;
        }
        int iidx = this.getOrCreateEntry(key);
        int ovalue = this._values[iidx];
        this._values[iidx] = Math.min(this._values[iidx] + amount, this.getMaxValue());
        if (this._values[iidx] != ovalue) {
            this.setModified(true);
            return true;
        }
        return false;
    }

    public String valueToString() {
        StringBuilder buf = new StringBuilder("[");
        for (int ii = 0; ii < this._keys.length; ++ii) {
            if (ii > 0) {
                buf.append(", ");
            }
            buf.append(this._keys[ii]).append("->").append(this._values[ii]);
        }
        return buf.append("]").toString();
    }

    protected int getOrCreateEntry(String key) {
        int iidx = ArrayUtil.binarySearch((Object[])this._keys, (int)0, (int)this._keys.length, (Comparable)((Object)key));
        if (iidx < 0) {
            iidx = -iidx - 1;
            String[] keys = new String[this._keys.length + 1];
            System.arraycopy(this._keys, 0, keys, 0, iidx);
            System.arraycopy(this._keys, iidx, keys, iidx + 1, this._keys.length - iidx);
            keys[iidx] = key;
            this._keys = keys;
            int[] values = new int[this._values.length + 1];
            System.arraycopy(this._values, 0, values, 0, iidx);
            System.arraycopy(this._values, iidx, values, iidx + 1, this._values.length - iidx);
            this._values = values;
        }
        return iidx;
    }

    protected abstract int getMaxValue();
}

