/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.viewer;

import com.samskivert.swing.util.SwingUtil;
import com.threerings.cast.CharacterManager;
import com.threerings.cast.ComponentRepository;
import com.threerings.cast.bundle.BundledComponentRepository;
import com.threerings.media.FrameManager;
import com.threerings.media.IconManager;
import com.threerings.media.image.ColorPository;
import com.threerings.media.image.ImageManager;
import com.threerings.media.tile.TileSetRepository;
import com.threerings.media.tile.bundle.BundledTileSetRepository;
import com.threerings.miso.tile.MisoTileManager;
import com.threerings.resource.ResourceManager;
import com.threerings.stage.Log;
import com.threerings.stage.tools.viewer.ViewerFrame;
import com.threerings.stage.util.StageContext;
import com.threerings.util.KeyDispatcher;
import com.threerings.util.KeyboardManager;
import com.threerings.util.MessageManager;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.IOException;

public class ViewerApp {
    protected ResourceManager _rmgr;
    protected MisoTileManager _tilemgr;
    protected ImageManager _imgr;
    protected BundledComponentRepository _crepo;
    protected ColorPository _colpos;
    protected MessageManager _mesgmgr;
    protected FrameManager _framemgr;
    protected ViewerFrame _frame;
    protected String _target;

    public ViewerApp(String[] args) throws IOException {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = env.getDefaultScreenDevice();
        Log.log.info((Object)("Graphics device [dev=" + gd + ", mem=" + gd.getAvailableAcceleratedMemory() + ", displayChange=" + gd.isDisplayChangeSupported() + ", fullScreen=" + gd.isFullScreenSupported() + "]."), new Object[0]);
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        DisplayMode dm = gd.getDisplayMode();
        Log.log.info((Object)("Display mode [bits=" + dm.getBitDepth() + ", wid=" + dm.getWidth() + ", hei=" + dm.getHeight() + ", refresh=" + dm.getRefreshRate() + "]."), new Object[0]);
        this._rmgr = new ResourceManager("rsrc");
        this._rmgr.initBundles(null, "config/resource/manager.properties", null);
        this._imgr = new ImageManager(this._rmgr, (Component)((Object)this._frame));
        this._tilemgr = new MisoTileManager(this._rmgr, this._imgr);
        this._tilemgr.setTileSetRepository((TileSetRepository)new BundledTileSetRepository(this._rmgr, this._imgr, "tilesets"));
        this._colpos = ColorPository.loadColorPository((ResourceManager)this._rmgr);
        this._crepo = new BundledComponentRepository(this._rmgr, this._imgr, "components");
        this._mesgmgr = new MessageManager("rsrc.i18n");
        this._frame = new ViewerFrame(gc);
        this._framemgr = FrameManager.newInstance((FrameManager.ManagedRoot)this._frame);
        ContextImpl ctx = new ContextImpl();
        this._frame.init(ctx, new CharacterManager(this._imgr, (ComponentRepository)this._crepo));
        String string = this._target = args.length > 0 ? args[0] : null;
        if (gd.isFullScreenSupported()) {
            Log.log.info((Object)"Entering full-screen exclusive mode.", new Object[0]);
            gd.setFullScreenWindow((Window)((Object)this._frame));
        } else {
            this._frame.setSize(640, 575);
            SwingUtil.centerWindow((Window)((Object)this._frame));
        }
    }

    public void run() {
        this._frame.setVisible(true);
        this._framemgr.start();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (ViewerApp.this._target != null) {
                    ViewerApp.this._frame.loadScene(ViewerApp.this._target);
                } else {
                    ViewerApp.this._frame.openScene(null);
                }
            }
        });
    }

    public static void main(String[] args) {
        try {
            ViewerApp app = new ViewerApp(args);
            app.run();
        }
        catch (IOException ioe) {
            System.err.println("Error initializing viewer app.");
            ioe.printStackTrace();
        }
    }

    protected class ContextImpl
    implements StageContext {
        protected ContextImpl() {
        }

        public FrameManager getFrameManager() {
            return ViewerApp.this._framemgr;
        }

        public MisoTileManager getTileManager() {
            return ViewerApp.this._tilemgr;
        }

        public ResourceManager getResourceManager() {
            return ViewerApp.this._rmgr;
        }

        public ImageManager getImageManager() {
            return ViewerApp.this._imgr;
        }

        public MessageManager getMessageManager() {
            return ViewerApp.this._mesgmgr;
        }

        public IconManager getIconManager() {
            return null;
        }

        public KeyboardManager getKeyboardManager() {
            return null;
        }

        public ComponentRepository getComponentRepository() {
            return ViewerApp.this._crepo;
        }

        public ColorPository getColorPository() {
            return ViewerApp.this._colpos;
        }

        public KeyDispatcher getKeyDispatcher() {
            return null;
        }

        public String xlate(String message) {
            return message;
        }

        public String xlate(String bundle, String message) {
            return message;
        }
    }
}

