/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.google.common.collect.Maps;
import com.samskivert.util.HashIntMap;
import com.threerings.media.tile.ImageProvider;
import com.threerings.media.tile.SimpleCachingImageProvider;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileSetIDBroker;
import com.threerings.media.tile.tools.xml.ObjectTileSetRuleSet;
import com.threerings.media.tile.tools.xml.TileSetRuleSet;
import com.threerings.media.tile.tools.xml.XMLTileSetParser;
import com.threerings.miso.tile.tools.xml.BaseTileSetRuleSet;
import com.threerings.stage.Log;
import com.threerings.stage.tools.editor.EditorConfig;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTileLoader
implements TileSetIDBroker {
    protected int _fakeID = Short.MAX_VALUE;
    protected Map<String, Integer> _idmap = Maps.newHashMap();
    protected XMLTileSetParser _parser;
    protected ImageProvider _improv = new SimpleCachingImageProvider(){

        protected BufferedImage loadImage(String path) throws IOException {
            return ImageIO.read(new File(path));
        }
    };

    public TestTileLoader() {
        this._parser = new XMLTileSetParser();
        this._parser.addRuleSet("bundle/base", (TileSetRuleSet)new BaseTileSetRuleSet());
        this._parser.addRuleSet("bundle/object", (TileSetRuleSet)new ObjectTileSetRuleSet());
    }

    public HashIntMap<TileSet> loadTestTiles() {
        String directory = EditorConfig.getTestTileDirectory();
        HashIntMap map = new HashIntMap();
        File testdir = new File(directory);
        if (!testdir.isDirectory()) {
            Log.log.warning((Object)("Test tileset directory is not actually a directory: " + directory), new Object[0]);
            return map;
        }
        this.loadTestTilesFromDir(testdir, (HashIntMap<TileSet>)map);
        return map;
    }

    protected void loadTestTilesFromDir(File directory, HashIntMap<TileSet> sets) {
        String[] xml;
        File[] subdirs;
        for (File subdir : subdirs = directory.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) {
            this.loadTestTilesFromDir(subdir, sets);
        }
        for (String element : xml = directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        })) {
            File xmlfile = new File(directory, element);
            HashMap tiles = Maps.newHashMap();
            try {
                this._parser.loadTileSets(xmlfile, (Map)tiles);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Error while parsing " + xmlfile.getPath()), new Object[]{ioe});
                continue;
            }
            for (TileSet ts : tiles.values()) {
                String path = new File(directory, ts.getImagePath()).getPath();
                if (null == this._improv.getTileSetImage(path, null)) continue;
                ts.setImageProvider(this._improv);
                ts.setImagePath(path);
                sets.put(this.getTileSetID(path), (Object)ts);
            }
        }
    }

    public int getTileSetID(String tileSetPath) {
        Integer id = this._idmap.get(tileSetPath);
        if (null == id) {
            id = this._fakeID--;
            this._idmap.put(tileSetPath, id);
        }
        return id;
    }

    public boolean tileSetMapped(String tilesetPath) {
        return this._idmap.containsKey(tilesetPath);
    }

    public void commit() {
    }
}

