/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.tourney.server;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.samskivert.io.PersistenceException;
import com.samskivert.util.Lifecycle;
import com.threerings.parlor.Log;
import com.threerings.parlor.tourney.data.TourneyConfig;
import com.threerings.parlor.tourney.server.TourneyManager;
import com.threerings.parlor.tourney.server.TourniesProvider;
import com.threerings.parlor.tourney.server.persist.TourneyRepository;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.InvocationException;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public abstract class TourniesManager
implements TourniesProvider,
Lifecycle.InitComponent {
    protected int _tourneyCount;
    protected Map<Comparable<?>, TourneyManager> _tourneys = Maps.newHashMap();
    @Inject
    protected Injector _injector;
    @Inject
    protected RootDObjectManager _omgr;
    @Inject
    protected TourneyRepository _tournrep;

    @Inject
    public TourniesManager(Lifecycle cycle) {
        cycle.addComponent((Lifecycle.BaseComponent)this);
    }

    public void init() {
        this.loadTourneyConfigs();
        this._omgr.newInterval(new Runnable(){

            public void run() {
                TourniesManager.this.updateTournies();
            }
        }).schedule(this.getIntervalDelay(), true);
    }

    @Override
    public void createTourney(ClientObject caller, TourneyConfig config, InvocationService.ResultListener listener) throws InvocationException {
        this.makeTourney(config, listener);
    }

    protected void makeTourney(TourneyConfig config, InvocationService.ResultListener listener) {
        TourneyManager tmgr = (TourneyManager)this._injector.getInstance(this.getTourneyManagerClass());
        int tournId = this._tourneyCount++;
        int tournOid = tmgr.init(config, Integer.valueOf(tournId));
        this._tourneys.put(Integer.valueOf(tournId), tmgr);
        if (listener != null) {
            listener.requestProcessed((Object)tournOid);
        }
    }

    protected void releaseTourney(Comparable<?> key) {
        this._tourneys.remove(key);
    }

    protected void loadTourneyConfigs() {
        try {
            ArrayList<TourneyConfig> tournies = this._tournrep.loadTournies();
            for (TourneyConfig config : tournies) {
                this.makeTourney(config, null);
            }
        }
        catch (PersistenceException pe) {
            Log.log.warning((Object)"Failed to load tourney configurations.", new Object[]{pe});
        }
    }

    protected void updateTournies() {
    }

    protected abstract Class<? extends TourneyManager> getTourneyManagerClass();

    protected abstract long getIntervalDelay();
}

