/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.card.trick.util;

import com.threerings.parlor.card.data.Card;
import com.threerings.parlor.card.data.Hand;
import com.threerings.parlor.card.data.PlayerCard;
import com.threerings.parlor.card.trick.data.TrickCardCodes;

public class TrickCardGameUtil
implements TrickCardCodes {
    public static int getTeamIndex(int pidx) {
        return pidx & 1;
    }

    public static int getOtherTeamIndex(int tidx) {
        return tidx ^ 1;
    }

    public static int getPartnerIndex(int pidx) {
        return pidx ^ 2;
    }

    public static int getTeamMemberIndex(int tidx, int midx) {
        return midx << 1 | tidx;
    }

    public static int getNextInClockwiseSequence(int pidx) {
        return pidx + 1 & 3;
    }

    public static int getRelativeLocation(int pidx1, int pidx2) {
        return pidx2 - pidx1 & 3;
    }

    public static int getLeftIndex(int pidx) {
        return pidx + 1 & 3;
    }

    public static int getRightIndex(int pidx) {
        return pidx + 3 & 3;
    }

    public static int getOppositeIndex(int pidx) {
        return pidx ^ 2;
    }

    public static boolean canFollowSuit(PlayerCard[] cardsPlayed, Hand hand) {
        return hand.getSuitMemberCount(cardsPlayed[0].card.getSuit()) > 0;
    }

    public static boolean containsCard(PlayerCard[] cards, Card card) {
        for (PlayerCard pc : cards) {
            if (!pc.card.equals(card)) continue;
            return true;
        }
        return false;
    }

    public static int countSuitMembers(PlayerCard[] cards, int suit) {
        int count = 0;
        for (PlayerCard pc : cards) {
            if (pc.card.getSuit() != suit) continue;
            ++count;
        }
        return count;
    }

    public static boolean followsSuit(PlayerCard[] cardsPlayed, Card card) {
        return cardsPlayed[0].card.getSuit() == card.getSuit();
    }

    public static PlayerCard getHighestInLeadSuit(PlayerCard[] cardsPlayed, int trumpSuit) {
        PlayerCard highest = cardsPlayed[0];
        for (int ii = 1; ii < cardsPlayed.length; ++ii) {
            PlayerCard other = cardsPlayed[ii];
            if ((other.card.getSuit() != highest.card.getSuit() || other.card.compareTo(highest.card) <= 0) && (other.card.getSuit() != trumpSuit || highest.card.getSuit() == trumpSuit)) continue;
            highest = other;
        }
        return highest;
    }
}

