/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.facebook;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.threerings.servlet.util.Parameters;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;

public class SignedRequest {
    protected final boolean _present;
    protected final String _token;
    protected final String _userId;
    protected static final int ONE_HOUR = 3600;
    protected static final Splitter PERIOD_SPLITTER = Splitter.on((char)'.');

    public SignedRequest(Parameters params, String appSecret) {
        Mac mac;
        JSONObject obj;
        this._present = params.has("signed_request");
        if (!this._present) {
            this._token = null;
            this._userId = null;
            return;
        }
        String param = params.get("signed_request");
        ArrayList split = Lists.newArrayList((Iterable)PERIOD_SPLITTER.split((CharSequence)param));
        Preconditions.checkArgument((split.size() == 2 ? 1 : 0) != 0, (String)"Not properly period delimited [req=%s]", (Object[])new Object[]{param});
        String encodedJson = (String)split.get(1);
        String json = new String(new Base64(true).decode(encodedJson), Charsets.UTF_8);
        try {
            obj = new JSONObject(json);
        }
        catch (JSONException je) {
            throw new RuntimeException("Invalid json [json=" + json + ", req=" + param + "]", je);
        }
        String algorithm = obj.optString("algorithm");
        this.checkArg("HMAC-SHA256".equals(algorithm), "Improper algorithm in json", param, json);
        long issuedAt = obj.optLong("issued_at");
        this.checkArg(System.currentTimeMillis() / 1000L - 3600L < issuedAt, "More than an hour old", param, json);
        SecretKeySpec key = new SecretKeySpec(appSecret.getBytes(Charsets.UTF_8), "HMACSHA256");
        try {
            mac = Mac.getInstance("HMACSHA256");
            mac.init(key);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException("Unable to initialize HMACSHA256. JVM busted?", gse);
        }
        byte[] digest = mac.doFinal(encodedJson.getBytes(Charsets.UTF_8));
        this.checkArg(Arrays.equals(new Base64(true).decode((String)split.get(0)), digest), "Invalid signature", param, json);
        this._token = obj.optString("oauth_token", null);
        this._userId = obj.optString("user_id", null);
    }

    public String getUserId() {
        if (!this.isAuthorized()) {
            throw new RuntimeException("No userId. Call isAuthorized before calling getUserId");
        }
        return this._userId;
    }

    public String getToken() {
        if (!this.isAuthorized()) {
            throw new RuntimeException("No token. Call isAuthorized before calling getToken");
        }
        return this._token;
    }

    public boolean isAuthorized() {
        return this._token != null;
    }

    public boolean isPresent() {
        return this._present;
    }

    protected void checkArg(boolean condition, String msg, String param, String json) {
        Preconditions.checkArgument((boolean)condition, (String)(msg + " [req=%s, json=%s]"), (Object[])new Object[]{param, json});
    }
}

