/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.facebook;

import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.FacebookJaxbRestClient;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.threerings.facebook.FQL;
import com.threerings.facebook.FQLQuery;
import com.threerings.facebook.Log;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FacebookSessionApi {
    public static FQL.Field UID = new FQL.Field("uid");
    public static FQL.Field NAME = new FQL.Field("name");
    public static Function<Map<FQL.Field, String>, String> FRIEND_FIELDS_TO_UID = new Function<Map<FQL.Field, String>, String>(){

        public String apply(Map<FQL.Field, String> map) {
            return map.get(UID);
        }
    };
    protected static Predicate<FQLQuery.Record> IS_APP_USER_PRED = new Predicate<FQLQuery.Record>(){

        public boolean apply(FQLQuery.Record rec) {
            return "1".equals(rec.getField(IS_APP_USER));
        }
    };
    protected static String USER_TABLE = "user";
    protected static String FRIEND_TABLE = "friend";
    protected static FQL.Field IS_APP_USER = new FQL.Field("is_app_user");
    protected static FQL.Field UID1 = new FQL.Field("uid1");
    protected static FQL.Field UID2 = new FQL.Field("uid2");
    protected FacebookJaxbRestClient _client;

    public FacebookSessionApi(String apiKey, String appSecret, String sessionKey) {
        this._client = new FacebookJaxbRestClient(apiKey, appSecret, sessionKey);
    }

    public String getMyName() {
        return this.getMyInfo(NAME).get(NAME);
    }

    public Map<FQL.Field, String> getMyInfo(FQL.Field ... userFields) {
        FQLQuery query = new FQLQuery(USER_TABLE, userFields, new FQL.Where(UID.is("me()")));
        HashMap values = Maps.newHashMap();
        try {
            FQLQuery.Record rec = query.run(this._client).iterator().next();
            if (rec != null) {
                for (FQL.Field field : userFields) {
                    values.put(field, rec.getField(field));
                }
            }
        }
        catch (FacebookException fe) {
            Log.log.warning((Object)"FacebookException fetching my user info", new Object[]{fe});
        }
        return values;
    }

    public Collection<String> getFriendsInApp() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.getFriendsInApp(UID), FRIEND_FIELDS_TO_UID));
    }

    public Set<Map<FQL.Field, String>> getFriendsInApp(FQL.Field ... userFields) {
        FQLQuery friendQuery = new FQLQuery(FRIEND_TABLE, new FQL.Field[]{UID2}, new FQL.Where(UID1.is("me()")));
        HashSet userFieldSet = Sets.newHashSet((Object[])userFields);
        userFieldSet.add(IS_APP_USER);
        FQLQuery userQuery = new FQLQuery(USER_TABLE, userFieldSet.toArray(new FQL.Field[0]), new FQL.Where(UID.in(Collections.singleton(friendQuery))));
        try {
            HashSet friends = Sets.newHashSet();
            for (FQLQuery.Record rec : Iterables.filter(userQuery.run(this._client), IS_APP_USER_PRED)) {
                HashMap friendValues = Maps.newHashMap();
                for (FQL.Field field : userFields) {
                    friendValues.put(field, rec.getField(field));
                }
                friends.add(friendValues);
            }
            return friends;
        }
        catch (FacebookException fe) {
            Log.log.warning((Object)"FacebookException fetching session friends.", new Object[]{"message", fe.getMessage()});
            return Collections.emptySet();
        }
    }
}

