/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.facebook;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.samskivert.io.StreamUtil;
import com.samskivert.net.HttpPostUtil;
import com.samskivert.util.ServiceWaiter;
import com.samskivert.util.StringUtil;
import com.threerings.facebook.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FBGraphUtil {
    protected static final String GRAPH_API_URL = "https://graph.facebook.com/";
    protected static final String EXCHANGE_SESSION = "oauth/exchange_sessions";
    protected static final int TIMEOUT = 15000;
    protected final String _fbAppId;
    protected final String _fbSecret;

    public FBGraphUtil(String facebookAppId, String facebookSecret) {
        this._fbAppId = facebookAppId;
        this._fbSecret = facebookSecret;
    }

    public String getThirdPartyId(String sessionKey, String fbUserId) {
        HashMap params = Maps.newHashMap();
        params.put("client_id", this._fbAppId);
        params.put("client_secret", this._fbSecret);
        params.put("sessions", sessionKey);
        SessionExchangeResult[] exchanges = this.getResult(EXCHANGE_SESSION, params, SessionExchangeResult[].class, true);
        if (exchanges == null || exchanges.length != 1) {
            Log.log.warning((Object)"Invalid session exchange result", new Object[]{"exchanges", exchanges});
            return null;
        }
        params.clear();
        params.put("fields", "third_party_id");
        params.put("access_token", exchanges[0].access_token);
        return this.getResult((String)fbUserId, (Map<String, String>)params, ThirdPartyIdResult.class).third_party_id;
    }

    protected <T> T getResult(String apiUrl, Map<String, String> params, Class<T> clazz) {
        return this.getResult(apiUrl, params, clazz, false);
    }

    protected <T> T getResult(String apiUrl, Map<String, String> params, Class<T> clazz, boolean httpPost) {
        Iterator<Map.Entry<String, String>> entryIter = params.entrySet().iterator();
        StringBuilder paramString = new StringBuilder();
        while (entryIter.hasNext()) {
            Map.Entry<String, String> entry = entryIter.next();
            paramString.append(StringUtil.encode((String)entry.getKey())).append('=').append(StringUtil.encode((String)entry.getValue()));
            if (!entryIter.hasNext()) continue;
            paramString.append('&');
        }
        try {
            apiUrl = GRAPH_API_URL + apiUrl;
            String jsonString = httpPost ? HttpPostUtil.httpPost((URL)new URL(apiUrl), (String)paramString.toString(), (int)15000) : StreamUtil.toString((InputStream)new URL(apiUrl + "?" + paramString.toString()).openStream());
            return (T)new Gson().fromJson(jsonString, clazz);
        }
        catch (ServiceWaiter.TimeoutException e) {
            Log.log.warning((Object)"TimeoutException waiting graph request", new Object[]{"apiUrl", apiUrl, "params", paramString, e});
        }
        catch (IOException e) {
            Log.log.warning((Object)"IOException fetching graph request", new Object[]{"apiUrl", apiUrl, "params", paramString, e});
        }
        return null;
    }

    protected static class ThirdPartyIdResult {
        public String third_party_id;
        public String id;

        protected ThirdPartyIdResult() {
        }
    }

    protected static class SessionExchangeResult {
        public String access_token;
        public int expires;

        protected SessionExchangeResult() {
        }
    }
}

