/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.HashIntMap;
import com.threerings.util.KeyTranslator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTranslatorImpl
implements KeyTranslator {
    protected HashIntMap<KeyRecord> _keys = new HashIntMap();
    protected HashMap<Character, KeyRecord> _charCommands = Maps.newHashMap();
    protected static final int DEFAULT_REPEAT_RATE = 5;
    protected static final long DEFAULT_REPEAT_DELAY = 500L;

    public void addPressCommand(int keyCode, String command) {
        this.addPressCommand(keyCode, command, 5);
    }

    public void addPressCommand(int keyCode, String command, int rate) {
        this.addPressCommand(keyCode, command, rate, 500L);
    }

    public void addPressCommand(int keyCode, String command, int rate, long repeatDelay) {
        KeyRecord krec = this.getKeyRecord(keyCode);
        krec.pressCommand = command;
        krec.repeatRate = rate;
        krec.repeatDelay = repeatDelay;
    }

    public void addReleaseCommand(int keyCode, String command) {
        KeyRecord krec = this.getKeyRecord(keyCode);
        krec.releaseCommand = command;
    }

    protected KeyRecord getKeyRecord(int keyCode) {
        KeyRecord krec = (KeyRecord)this._keys.get(keyCode);
        if (krec == null) {
            krec = new KeyRecord();
            this._keys.put(keyCode, (Object)krec);
        }
        return krec;
    }

    @Override
    public boolean hasCommand(int keyCode) {
        return this._keys.get(keyCode) != null;
    }

    @Override
    public boolean hasCommand(char ch) {
        return this._charCommands.get(Character.valueOf(ch)) != null;
    }

    @Override
    public String getPressCommand(int keyCode) {
        KeyRecord krec = (KeyRecord)this._keys.get(keyCode);
        return krec == null ? null : krec.pressCommand;
    }

    @Override
    public String getPressCommand(char ch) {
        KeyRecord krec = this._charCommands.get(Character.valueOf(ch));
        return krec == null ? null : krec.pressCommand;
    }

    @Override
    public String getReleaseCommand(int keyCode) {
        KeyRecord krec = (KeyRecord)this._keys.get(keyCode);
        return krec == null ? null : krec.releaseCommand;
    }

    @Override
    public String getReleaseCommand(char ch) {
        KeyRecord krec = this._charCommands.get(Character.valueOf(ch));
        return krec == null ? null : krec.releaseCommand;
    }

    @Override
    public int getRepeatRate(int keyCode) {
        KeyRecord krec = (KeyRecord)this._keys.get(keyCode);
        return krec == null ? 5 : krec.repeatRate;
    }

    @Override
    public int getRepeatRate(char ch) {
        KeyRecord krec = this._charCommands.get(Character.valueOf(ch));
        return krec == null ? 5 : krec.repeatRate;
    }

    @Override
    public long getRepeatDelay(int keyCode) {
        KeyRecord krec = (KeyRecord)this._keys.get(keyCode);
        return krec == null ? 500L : krec.repeatDelay;
    }

    @Override
    public long getRepeatDelay(char ch) {
        KeyRecord krec = this._charCommands.get(Character.valueOf(ch));
        return krec == null ? 500L : krec.repeatDelay;
    }

    @Override
    public Iterator<String> enumeratePressCommands() {
        ArrayList commands = Lists.newArrayList();
        for (KeyRecord rec : this._keys.values()) {
            commands.add(rec.pressCommand);
        }
        return commands.iterator();
    }

    @Override
    public Iterator<String> enumerateReleaseCommands() {
        ArrayList commands = Lists.newArrayList();
        for (KeyRecord rec : this._keys.values()) {
            commands.add(rec.releaseCommand);
        }
        return commands.iterator();
    }

    protected static class KeyRecord {
        public String pressCommand;
        public String releaseCommand;
        public int repeatRate;
        public long repeatDelay;

        protected KeyRecord() {
        }
    }
}

