/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.threerings.media.FrameManager;
import com.threerings.media.Log;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.VolatileImage;

public class BackFrameManager
extends FrameManager {
    protected VolatileImage _backimg;
    protected Graphics2D _bgfx;
    protected Graphics2D _fgfx;

    protected void paint(long tickStamp) {
        boolean incremental = true;
        do {
            int valres;
            GraphicsConfiguration gc = this._window.getGraphicsConfiguration();
            if (this._backimg == null || this._backimg.getWidth() != this._window.getWidth() || this._backimg.getHeight() != this._window.getHeight()) {
                this.createBackBuffer(gc);
            }
            if ((valres = this._backimg.validate(gc)) == 2) {
                Log.log.info((Object)"Back buffer incompatible, recreating.", new Object[0]);
                this.createBackBuffer(gc);
            }
            if (valres != 0) {
                if (this._bgfx != null) {
                    this._bgfx.dispose();
                }
                this._bgfx = this._backimg.createGraphics();
                if (this._fgfx != null) {
                    this._fgfx.dispose();
                    this._fgfx = null;
                }
                incremental = false;
            }
            if (!incremental) {
                this._root.getRootPane().revalidate();
                this._root.getRootPane().repaint();
            }
            if (!this.paint(this._bgfx)) {
                return;
            }
            if (this._fgfx == null) {
                Component comp = this._root instanceof Component ? (Component)((Object)this._root) : this._window;
                this._fgfx = (Graphics2D)comp.getGraphics();
            }
            this._fgfx.drawImage(this._backimg, 0, 0, null);
            incremental = false;
        } while (this._backimg.contentsLost());
    }

    protected Graphics2D createGraphics() {
        return this._backimg.createGraphics();
    }

    protected void restoreFromBack(Rectangle dirty) {
        if (this._fgfx == null || this._backimg == null) {
            return;
        }
        this._fgfx.setClip(dirty);
        this._fgfx.drawImage(this._backimg, 0, 0, null);
        this._fgfx.setClip(null);
    }

    protected void createBackBuffer(GraphicsConfiguration gc) {
        if (this._backimg != null) {
            this._backimg.flush();
            this._bgfx.dispose();
        }
        int width = this._window.getWidth();
        int height = this._window.getHeight();
        this._backimg = gc.createCompatibleVolatileImage(width, height);
        this._bgfx = (Graphics2D)this._backimg.getGraphics();
        this._bgfx.fillRect(0, 0, width, height);
        if (this._fgfx != null) {
            this._fgfx.dispose();
            this._fgfx = null;
        }
    }
}

