/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.tile;

import com.google.common.collect.Lists;
import com.samskivert.util.CheapIntMap;
import com.samskivert.util.QuickSort;
import com.threerings.media.image.BufferedMirage;
import com.threerings.media.image.ImageManager;
import com.threerings.media.image.ImageUtil;
import com.threerings.media.tile.NoSuchTileSetException;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileManager;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileUtil;
import com.threerings.miso.Log;
import com.threerings.miso.data.MisoSceneModel;
import com.threerings.miso.tile.BaseTile;
import com.threerings.miso.tile.FringeConfiguration;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoFringer {
    protected static final int NORTH = 1;
    protected static final int NORTHEAST = 2;
    protected static final int EAST = 4;
    protected static final int SOUTHEAST = 8;
    protected static final int SOUTH = 16;
    protected static final int SOUTHWEST = 32;
    protected static final int WEST = 64;
    protected static final int NORTHWEST = 128;
    protected static final int NUM_FRINGEBITS = 8;
    protected static final int[][] FLAGMATRIX;
    protected static final int[] FRINGETILES;
    protected static final int[] BITS_TO_INDEX;
    protected ImageManager _imgr;
    protected TileManager _tmgr;
    protected FringeConfiguration _fringeconf;
    protected CheapIntMap _fringers = new CheapIntMap(16);

    public AutoFringer(FringeConfiguration fringeconf, ImageManager imgr, TileManager tmgr) {
        this._fringeconf = fringeconf;
        this._imgr = imgr;
        this._tmgr = tmgr;
    }

    public FringeConfiguration getFringeConf() {
        return this._fringeconf;
    }

    public BaseTile getFringeTile(MisoSceneModel scene, int col, int row, Map<FringeTile, WeakReference<FringeTile>> fringes, Map<Long, BufferedImage> masks) {
        int underset = this.adjustTileSetId(scene.getBaseTileId(col, row) >> 16);
        this._fringers.clear();
        boolean passable = true;
        int maxy = row + 2;
        for (int y = row - 1; y < maxy; ++y) {
            int maxx = col + 2;
            for (int x = col - 1; x < maxx; ++x) {
                int btid;
                int baseset;
                int pri;
                if (x == col && y == row || (pri = this._fringeconf.fringesOn(baseset = this.adjustTileSetId((btid = scene.getBaseTileId(x, y)) <= 0 ? scene.getDefaultBaseTileSet() : btid >> 16), underset)) == -1) continue;
                FringerRec fringer = (FringerRec)this._fringers.get(baseset);
                if (fringer == null) {
                    fringer = new FringerRec(baseset, pri);
                    this._fringers.put(baseset, (Object)fringer);
                }
                fringer.bits |= FLAGMATRIX[y - row + 1][x - col + 1];
                if (!passable || btid <= 0) continue;
                try {
                    BaseTile bt = (BaseTile)this._tmgr.getTile(btid);
                    passable = bt.isPassable();
                    continue;
                }
                catch (NoSuchTileSetException nstse) {
                    Log.log.warning((Object)"Autofringer couldn't find a base set while attempting to figure passability", new Object[]{nstse});
                }
            }
        }
        int numfringers = this._fringers.size();
        if (numfringers == 0) {
            return null;
        }
        FringerRec[] frecs = new FringerRec[numfringers];
        int pp = 0;
        for (int ii = 0; ii < 16; ++ii) {
            FringerRec rec = (FringerRec)this._fringers.getValue(ii);
            if (rec == null) continue;
            frecs[pp++] = rec;
        }
        return this.composeFringeTile(frecs, fringes, TileUtil.getTileHash(col, row), passable, masks);
    }

    protected FringeTile composeFringeTile(FringerRec[] fringers, Map<FringeTile, WeakReference<FringeTile>> fringes, int hashValue, boolean passable, Map<Long, BufferedImage> masks) {
        FringeTile fringe;
        QuickSort.sort((Comparable[])fringers);
        ArrayList keys = Lists.newArrayList();
        for (FringerRec fringer : fringers) {
            int[] indexes = this.getFringeIndexes(fringer.bits);
            FringeConfiguration.FringeTileSetRecord tsr = this._fringeconf.getFringe(fringer.baseset, hashValue);
            int fringeset = tsr.fringe_tsid;
            for (int index : indexes) {
                keys.add(((long)fringer.baseset << 32) + (long)(fringeset << 16) + (long)index);
            }
        }
        long[] fringeId = new long[keys.size()];
        for (int ii = 0; ii < fringeId.length; ++ii) {
            fringeId[ii] = (Long)keys.get(ii);
        }
        FringeTile frTile = new FringeTile(fringeId, passable);
        WeakReference<FringeTile> result = fringes.get(frTile);
        if (result != null && (fringe = (FringeTile)result.get()) != null) {
            return fringe;
        }
        BufferedImage img = null;
        for (FringerRec fringer : fringers) {
            int[] indexes = this.getFringeIndexes(fringer.bits);
            FringeConfiguration.FringeTileSetRecord tsr = this._fringeconf.getFringe(fringer.baseset, hashValue);
            for (int index : indexes) {
                try {
                    img = this.getTileImage(img, tsr, fringer.baseset, index, hashValue, masks);
                }
                catch (NoSuchTileSetException nstse) {
                    Log.log.warning((Object)"Autofringer couldn't find a needed tileset", new Object[]{nstse});
                }
            }
        }
        frTile.setImage(new BufferedMirage(img));
        fringes.put(frTile, new WeakReference<FringeTile>(frTile));
        return frTile;
    }

    protected BufferedImage getTileImage(BufferedImage img, FringeConfiguration.FringeTileSetRecord tsr, int baseset, int index, int hashValue, Map<Long, BufferedImage> masks) throws NoSuchTileSetException {
        int fringeset = tsr.fringe_tsid;
        TileSet fset = this._tmgr.getTileSet(fringeset);
        if (!tsr.mask) {
            Tile stamp = fset.getTile(index);
            return this.stampTileImage(stamp, img, stamp.getWidth(), stamp.getHeight());
        }
        Long maskkey = ((long)baseset << 32) + (long)(fringeset << 16) + (long)index;
        BufferedImage mask = masks.get(maskkey);
        if (mask == null) {
            BufferedImage fsrc = this._tmgr.getTileSet(fringeset).getRawTileImage(index);
            BufferedImage bsrc = this._tmgr.getTileSet(baseset).getRawTileImage(0);
            mask = ImageUtil.composeMaskedImage((ImageUtil.ImageCreator)this._imgr, fsrc, bsrc);
            masks.put(maskkey, mask);
        }
        return this.stampTileImage(mask, img, mask.getWidth(null), mask.getHeight(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage stampTileImage(Object stamp, BufferedImage ftimg, int width, int height) {
        if (ftimg == null) {
            ftimg = this._imgr.createImage(width, height, 2);
        }
        Graphics2D gfx = (Graphics2D)ftimg.getGraphics();
        try {
            if (stamp instanceof Tile) {
                ((Tile)stamp).paint(gfx, 0, 0);
            } else {
                gfx.drawImage((Image)((BufferedImage)stamp), 0, 0, null);
            }
        }
        finally {
            gfx.dispose();
        }
        return ftimg;
    }

    protected int[] getFringeIndexes(int bits) {
        int start;
        int index = BITS_TO_INDEX[bits];
        if (index != -1) {
            int[] ret = new int[]{index};
            return ret;
        }
        for (start = 0; (1 << start & bits) != 0 && start < 8; ++start) {
        }
        if (start == 8) {
            return new int[0];
        }
        ArrayList indexes = Lists.newArrayList();
        int weebits = 0;
        int ii = (start + 1) % 8;
        while (ii != start) {
            if ((1 << ii & bits) != 0) {
                weebits |= 1 << ii;
            } else if (weebits != 0) {
                index = BITS_TO_INDEX[weebits];
                if (index != -1) {
                    indexes.add(index);
                }
                weebits = 0;
            }
            ii = (ii + 1) % 8;
        }
        if (weebits != 0 && (index = BITS_TO_INDEX[weebits]) != -1) {
            indexes.add(index);
        }
        int[] ret = new int[indexes.size()];
        for (int ii2 = 0; ii2 < ret.length; ++ii2) {
            ret[ii2] = (Integer)indexes.get(ii2);
        }
        return ret;
    }

    protected int adjustTileSetId(int tileSetId) {
        return tileSetId;
    }

    static {
        int ii;
        FLAGMATRIX = new int[][]{{2, 14, 8}, {131, 0, 56}, {128, 224, 32}};
        FRINGETILES = new int[]{8, 56, 32, 14, 224, 2, 131, 128, 227, 143, 248, 62, 251, 239, 191, 254, 255};
        int num = 256;
        BITS_TO_INDEX = new int[num];
        for (ii = 0; ii < num; ++ii) {
            AutoFringer.BITS_TO_INDEX[ii] = -1;
        }
        for (ii = 0; ii < FRINGETILES.length; ++ii) {
            AutoFringer.BITS_TO_INDEX[AutoFringer.FRINGETILES[ii]] = ii;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FringerRec
    implements Comparable<FringerRec> {
        int baseset;
        int priority;
        int bits;

        public FringerRec(int base, int pri) {
            this.baseset = base;
            this.priority = pri;
        }

        @Override
        public int compareTo(FringerRec o) {
            return this.priority - o.priority;
        }

        public String toString() {
            return "[base=" + this.baseset + ", pri=" + this.priority + ", bits=" + Integer.toString(this.bits, 16) + "]";
        }
    }

    public static class FringeTile
    extends BaseTile {
        protected long[] _fringeId;

        public FringeTile(long[] fringeId, boolean passable) {
            this.setPassable(passable);
            this._fringeId = fringeId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FringeTile)) {
                return false;
            }
            FringeTile fObj = (FringeTile)obj;
            return this._passable == fObj._passable && Arrays.equals(this._fringeId, fObj._fringeId);
        }

        public int hashCode() {
            return Arrays.hashCode(this._fringeId);
        }
    }
}

