/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sound;

import com.google.common.collect.Sets;
import com.samskivert.util.Interval;
import com.samskivert.util.ObserverList;
import com.samskivert.util.RunQueue;
import com.threerings.media.sound.SoundEnabledObserver;
import java.util.Set;

public abstract class SoundPlayer {
    public static final float PAN_LEFT = -1.0f;
    public static final float PAN_RIGHT = 1.0f;
    public static final float PAN_CENTER = 0.0f;
    public static final SoundType DEFAULT = new SoundType("default");
    protected float _clipVol = 1.0f;
    protected Set<SoundType> _disabledTypes = Sets.newHashSet();
    protected ObserverList<SoundEnabledObserver> _enabledObservers = ObserverList.newFastUnsafe();

    public abstract void shutdown();

    public String summarizeState() {
        StringBuilder buf = new StringBuilder();
        buf.append("clipVol=").append(this._clipVol);
        buf.append(", disabled=[");
        int ii = 0;
        for (SoundType soundType : this._disabledTypes) {
            if (ii++ > 0) {
                buf.append(", ");
            }
            buf.append(soundType);
        }
        return buf.append("]").toString();
    }

    public boolean isEnabled(SoundType type) {
        return !this._disabledTypes.contains(type);
    }

    public boolean shouldPlay(SoundType type) {
        if (type == null) {
            type = DEFAULT;
        }
        return this._clipVol != 0.0f && this.isEnabled(type);
    }

    public void setEnabled(final SoundType type, final boolean enabled) {
        boolean changed = enabled ? this._disabledTypes.remove(type) : this._disabledTypes.add(type);
        if (changed) {
            this._enabledObservers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<SoundEnabledObserver>(){

                public boolean apply(SoundEnabledObserver observer) {
                    observer.enabledChanged(type, enabled);
                    return true;
                }
            });
        }
    }

    public void addSoundEnabledObserver(SoundEnabledObserver listener) {
        this._enabledObservers.add((Object)listener);
    }

    public void removeSoundEnabledObserver(SoundEnabledObserver listener) {
        this._enabledObservers.remove((Object)listener);
    }

    public void setClipVolume(float vol) {
        this._clipVol = Math.max(0.0f, Math.min(1.0f, vol));
    }

    public float getClipVolume() {
        return this._clipVol;
    }

    public abstract void lock(String var1, String ... var2);

    public abstract void unlock(String var1, String ... var2);

    public boolean play(SoundType type, String pkgPath, String key) {
        return this.play(type, pkgPath, key, 0, 0.0f);
    }

    public boolean play(SoundType type, String pkgPath, String key, float pan) {
        return this.play(type, pkgPath, key, 0, pan);
    }

    public boolean play(SoundType type, String pkgPath, String key, int delay) {
        return this.play(type, pkgPath, key, delay, 0.0f);
    }

    public boolean play(SoundType type, final String pkgPath, final String key, int delay, final float pan) {
        if (!this.shouldPlay(type)) {
            return false;
        }
        if (delay > 0) {
            new Interval(this.getSoundQueue()){

                public void expired() {
                    SoundPlayer.this.play(pkgPath, key, pan);
                }
            }.schedule((long)delay);
        } else {
            this.play(pkgPath, key, pan);
        }
        return true;
    }

    protected abstract void play(String var1, String var2, float var3);

    public Frob loop(SoundType type, String pkgPath, String key) {
        return this.loop(type, pkgPath, key, 0.0f);
    }

    public Frob loop(SoundType type, String pkgPath, String key, float pan) {
        if (!this.shouldPlay(type)) {
            return null;
        }
        return this.loop(pkgPath, key, pan);
    }

    protected abstract Frob loop(String var1, String var2, float var3);

    protected abstract RunQueue getSoundQueue();

    public static interface Frob {
        public void stop();

        public void setVolume(float var1);

        public float getVolume();

        public void setPan(float var1);

        public float getPan();
    }

    public static class SoundType {
        protected String _strname;

        public SoundType(String strname) {
            this._strname = strname;
        }

        public String toString() {
            return this._strname;
        }
    }
}

