/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.io.ByteArrayOutInputStream;
import com.samskivert.net.AttachableURLFactory;
import com.samskivert.util.StringUtil;
import com.threerings.geom.GeomUtil;
import com.threerings.media.image.ColorPository;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageUtil;
import com.threerings.resource.Log;
import com.threerings.resource.ResourceManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class Handler
extends URLStreamHandler {
    protected static ResourceManager _rmgr;

    public static void registerHandler(ResourceManager rmgr) {
        if (_rmgr == null) {
            AttachableURLFactory.attachHandler((String)"resource", Handler.class);
        }
        _rmgr = rmgr;
    }

    protected int hashCode(URL url) {
        return String.valueOf(url).hashCode();
    }

    protected boolean equals(URL u1, URL u2) {
        return String.valueOf(u1).equals(String.valueOf(u2));
    }

    protected URLConnection openConnection(URL url) throws IOException {
        return new URLConnection(url){
            protected InputStream _stream;

            public void connect() throws IOException {
                String bundle = this.url.getHost();
                String path = this.url.getPath().substring(1);
                try {
                    String query = this.url.getQuery();
                    this._stream = !StringUtil.isBlank((String)query) ? Handler.this.getStream(bundle, path, query) : (StringUtil.isBlank((String)bundle) ? _rmgr.getResource(path) : _rmgr.getResource(bundle, path));
                    this.connected = true;
                }
                catch (IOException ioe) {
                    Log.log.warning((Object)"Could not find resource", new Object[]{"url", this.url, "error", ioe.getMessage()});
                    throw ioe;
                }
            }

            public InputStream getInputStream() throws IOException {
                if (!this.connected) {
                    this.connect();
                }
                return this._stream;
            }

            public Permission getPermission() throws IOException {
                return null;
            }
        };
    }

    protected InputStream getStream(String bundle, String path, String query) throws IOException {
        if (!path.endsWith(".png")) {
            Log.log.warning((Object)"Requested sub-tile of non-PNG resource", new Object[]{"bundle", bundle, "path", path, "dims", query});
            return _rmgr.getResource(bundle, path);
        }
        String[] bits = StringUtil.split((String)query, (String)"&");
        int width = -1;
        int height = -1;
        int tidx = -1;
        HashMap zations = null;
        try {
            for (String bit : bits) {
                if (bit.startsWith("width=")) {
                    width = Integer.parseInt(bit.substring(6));
                    continue;
                }
                if (bit.startsWith("height=")) {
                    height = Integer.parseInt(bit.substring(7));
                    continue;
                }
                if (bit.startsWith("tile=")) {
                    tidx = Integer.parseInt(bit.substring(5));
                    continue;
                }
                if (!bit.startsWith("zation=")) continue;
                String[] zation = bit.substring(7).split(":");
                if (zations == null) {
                    zations = Maps.newHashMap();
                }
                zations.put(zation[0], zation[1]);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (width <= 0 || height <= 0 || tidx < 0) {
            Log.log.warning((Object)"Bogus sub-image dimensions", new Object[]{"bundle", bundle, "path", path, "dims", query});
            throw new FileNotFoundException(path);
        }
        BufferedImage src = StringUtil.isBlank((String)bundle) ? _rmgr.getImageResource(path) : _rmgr.getImageResource(bundle, path);
        Rectangle trect = GeomUtil.getTile(src.getWidth(), src.getHeight(), width, height, tidx);
        BufferedImage tile = src.getSubimage(trect.x, trect.y, trect.width, trect.height);
        if (zations != null) {
            ColorPository pository = ColorPository.loadColorPository(_rmgr);
            ArrayList colorizations = Lists.newArrayList();
            for (Map.Entry entry : zations.entrySet()) {
                String zClass = (String)entry.getKey();
                String zColor = (String)entry.getValue();
                Colorization zation = null;
                try {
                    zation = pository.getColorization(zClass, Integer.parseInt(zColor));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (zation == null) {
                    zation = pository.getColorization(zClass, zColor);
                }
                if (zation == null) {
                    Log.log.warning((Object)"Couldn't figure out requested zation", new Object[]{"class", zClass, "color", zColor});
                    continue;
                }
                colorizations.add(zation);
            }
            tile = ImageUtil.recolorImage(tile, colorizations.toArray(new Colorization[colorizations.size()]));
        }
        ByteArrayOutInputStream data = new ByteArrayOutInputStream();
        ImageIO.write((RenderedImage)tile, "PNG", (OutputStream)data);
        return data.getInputStream();
    }
}

