/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.threerings.openal.ClipBuffer;
import com.threerings.openal.SoundGroup;
import com.threerings.openal.Source;

public class Sound {
    protected SoundGroup _group;
    protected ClipBuffer _buffer;
    protected Source _source;
    protected int _stateDesired;
    protected boolean _loopDesired;
    protected float _px;
    protected float _py;
    protected float _pz;
    protected float _vx;
    protected float _vy;
    protected float _vz;
    protected float _gain = 1.0f;
    protected boolean _sourceRelative;
    protected float _minGain;
    protected float _maxGain = 1.0f;
    protected float _referenceDistance = 1.0f;
    protected float _rolloffFactor = 1.0f;
    protected float _maxDistance = Float.MAX_VALUE;
    protected float _pitch = 1.0f;
    protected float _dx;
    protected float _dy;
    protected float _dz;
    protected float _coneInnerAngle = 360.0f;
    protected float _coneOuterAngle = 360.0f;
    protected float _coneOuterGain;

    public SoundGroup getGroup() {
        return this._group;
    }

    public ClipBuffer getBuffer() {
        return this._buffer;
    }

    public void setPosition(float x, float y, float z) {
        if (this._source != null) {
            this._source.setPosition(x, y, z);
        }
        this._px = x;
        this._py = y;
        this._pz = z;
    }

    public void setVelocity(float x, float y, float z) {
        if (this._source != null) {
            this._source.setVelocity(x, y, z);
        }
        this._vx = x;
        this._vy = y;
        this._vz = z;
    }

    public void setGain(float gain) {
        this._gain = gain;
        this.updateSourceGain();
    }

    public void setSourceRelative(boolean relative) {
        if (this._source != null) {
            this._source.setSourceRelative(relative);
        }
        this._sourceRelative = relative;
    }

    public void setMinGain(float gain) {
        if (this._source != null) {
            this._source.setMinGain(gain);
        }
        this._minGain = gain;
    }

    public void setMaxGain(float gain) {
        if (this._source != null) {
            this._source.setMaxGain(gain);
        }
        this._maxGain = gain;
    }

    public void setReferenceDistance(float distance) {
        if (this._source != null) {
            this._source.setReferenceDistance(distance);
        }
        this._referenceDistance = distance;
    }

    public void setRolloffFactor(float rolloff) {
        if (this._source != null) {
            this._source.setRolloffFactor(rolloff);
        }
        this._rolloffFactor = rolloff;
    }

    public void setMaxDistance(float distance) {
        if (this._source != null) {
            this._source.setMaxDistance(distance);
        }
        this._maxDistance = distance;
    }

    public void setPitch(float pitch) {
        if (this._source != null) {
            this._source.setPitch(pitch);
        }
        this._pitch = pitch;
    }

    public void setDirection(float x, float y, float z) {
        if (this._source != null) {
            this._source.setDirection(x, y, z);
        }
        this._dx = x;
        this._dy = y;
        this._dz = z;
    }

    public void setConeInnerAngle(float angle) {
        if (this._source != null) {
            this._source.setConeInnerAngle(angle);
        }
        this._coneInnerAngle = angle;
    }

    public void setConeOuterAngle(float angle) {
        if (this._source != null) {
            this._source.setConeOuterAngle(angle);
        }
        this._coneOuterAngle = angle;
    }

    public void setConeOuterGain(float gain) {
        if (this._source != null) {
            this._source.setConeOuterGain(gain);
        }
        this._coneOuterGain = gain;
    }

    public boolean play(boolean allowDefer) {
        return this.play(allowDefer, false, null);
    }

    public boolean loop(boolean allowDefer) {
        return this.play(allowDefer, true, null);
    }

    public boolean play(StartObserver obs, boolean loop) {
        return this.play(true, loop, obs);
    }

    public void pause() {
        if (this._source != null) {
            this._source.pause();
        } else {
            this._stateDesired = 4115;
        }
    }

    public void stop() {
        if (this._source != null) {
            this._source.stop();
        } else {
            this._stateDesired = 4116;
        }
    }

    public boolean isPlaying() {
        return this._source != null && this._source.isPlaying();
    }

    protected Sound(SoundGroup group, ClipBuffer buffer) {
        this._group = group;
        this._buffer = buffer;
    }

    protected boolean play(boolean allowDefer, boolean loop, final StartObserver obs) {
        if (this._buffer == null) {
            if (obs != null) {
                obs.soundStarted(null);
            }
            return false;
        }
        if (!this._buffer.isPlayable()) {
            if (allowDefer) {
                this._stateDesired = 4114;
                this._loopDesired = loop;
                this._buffer.resolve(new ClipBuffer.Observer(){

                    public void clipLoaded(ClipBuffer buffer) {
                        if (Sound.this._stateDesired == 4116) {
                            return;
                        }
                        Sound.this.play(false, Sound.this._loopDesired, obs);
                        if (Sound.this._stateDesired == 4115) {
                            Sound.this.pause();
                        }
                    }

                    public void clipFailed(ClipBuffer buffer) {
                        if (obs != null && Sound.this._stateDesired != 4116) {
                            obs.soundStarted(Sound.this);
                        }
                    }
                });
                return true;
            }
            if (obs != null) {
                obs.soundStarted(null);
            }
            return false;
        }
        if (obs != null) {
            obs.soundStarted(this);
        }
        if (this._source == null) {
            this._source = this._group.acquireSource(this);
            if (this._source == null) {
                return false;
            }
            this._source.setBuffer(this._buffer.getBuffer());
            this._buffer.sourceBound();
            this._source.setPosition(this._px, this._py, this._pz);
            this._source.setVelocity(this._vx, this._vy, this._vz);
            this.updateSourceGain();
            this._source.setSourceRelative(this._sourceRelative);
            this._source.setMinGain(this._minGain);
            this._source.setMaxGain(this._maxGain);
            this._source.setReferenceDistance(this._referenceDistance);
            this._source.setRolloffFactor(this._rolloffFactor);
            this._source.setMaxDistance(this._maxDistance);
            this._source.setPitch(this._pitch);
            this._source.setDirection(this._dx, this._dy, this._dz);
            this._source.setConeInnerAngle(this._coneInnerAngle);
            this._source.setConeOuterAngle(this._coneOuterAngle);
            this._source.setConeOuterGain(this._coneOuterGain);
        }
        this._source.setLooping(loop);
        this._source.play();
        return true;
    }

    protected void updateSourceGain() {
        if (this._source != null) {
            this._source.setGain(this._gain * this._group.getInheritedBaseGain());
        }
    }

    protected boolean reclaim() {
        if (this._source != null && this._source.isStopped()) {
            this._source.setBuffer(null);
            this._buffer.sourceUnbound();
            this._source = null;
            return true;
        }
        return false;
    }

    public static interface StartObserver {
        public void soundStarted(Sound var1);
    }
}

