/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.google.common.collect.Lists;
import com.threerings.openal.SoundManager;
import com.threerings.openal.Stream;
import com.threerings.openal.StreamDecoder;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class FileStream
extends Stream {
    protected QueuedFile _file;
    protected StreamDecoder _decoder;
    protected ArrayList<QueuedFile> _queue = Lists.newArrayList();

    public FileStream(SoundManager soundmgr, File file, boolean loop) throws IOException {
        super(soundmgr);
        this._file = new QueuedFile(file, loop);
        this._decoder = StreamDecoder.createInstance(file);
    }

    public void queueFile(File file, boolean loop) {
        this._queue.add(new QueuedFile(file, loop));
    }

    protected int getFormat() {
        return this._decoder.getFormat();
    }

    protected int getFrequency() {
        return this._decoder.getFrequency();
    }

    protected int populateBuffer(ByteBuffer buf) throws IOException {
        int read = this._decoder.read(buf);
        while (buf.hasRemaining() && (!this._queue.isEmpty() || this._file.loop)) {
            if (!this._queue.isEmpty()) {
                this._file = this._queue.remove(0);
            }
            this._decoder = StreamDecoder.createInstance(this._file.file);
            read = Math.max(0, read);
            read += this._decoder.read(buf);
        }
        return read;
    }

    protected class QueuedFile {
        public File file;
        public boolean loop;

        public QueuedFile(File file, boolean loop) {
            this.file = file;
            this.loop = loop;
        }
    }
}

