/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.samskivert.util.ObserverList;
import com.threerings.openal.Buffer;
import com.threerings.openal.Clip;
import com.threerings.openal.ClipProvider;
import com.threerings.openal.Log;
import com.threerings.openal.SoundManager;
import java.io.IOException;
import org.lwjgl.openal.AL10;

public class ClipBuffer {
    protected SoundManager _manager;
    protected ClipProvider _provider;
    protected String _path;
    protected int _state;
    protected Buffer _buffer;
    protected int _size;
    protected ObserverList<Observer> _observers = new ObserverList(2);
    protected int _bound;
    protected static final int UNLOADED = 0;
    protected static final int LOADING = 1;
    protected static final int LOADED = 2;
    protected static final int UNLOADING = 3;

    public static String makeKey(ClipProvider provider, String path) {
        return provider + ":" + path;
    }

    public ClipBuffer(SoundManager manager, ClipProvider provider, String path) {
        this._manager = manager;
        this._provider = provider;
        this._path = path;
    }

    public String getKey() {
        return ClipBuffer.makeKey(this._provider, this._path);
    }

    public ClipProvider getClipProvider() {
        return this._provider;
    }

    public String getPath() {
        return this._path;
    }

    public boolean isPlayable() {
        return this._state == 2;
    }

    public Buffer getBuffer() {
        return this._buffer;
    }

    public int getSize() {
        return this._size;
    }

    public void resolve(Observer observer) {
        if (this._state == 3) {
            this._state = 2;
            this._manager.restoreClip(this);
        }
        if (this._state == 2) {
            if (observer != null) {
                observer.clipLoaded(this);
            }
            return;
        }
        if (observer != null) {
            this._observers.add((Object)observer);
        }
        if (this._state == 1) {
            return;
        }
        this._buffer = new Buffer(this._manager);
        int errno = AL10.alGetError();
        if (errno != 0) {
            Log.log.warning((Object)("Failed to create buffer [key=" + this.getKey() + ", errno=" + errno + "]."), new Object[0]);
            this._buffer = null;
            this._manager.queueClipFailure(this);
        } else {
            this._state = 1;
            this._manager.queueClipLoad(this);
        }
    }

    public void dispose() {
        if (this._buffer != null) {
            if (this._bound > 0) {
                this._state = 3;
                return;
            }
            this._buffer.delete();
            this._buffer = null;
            this._state = 0;
        }
    }

    protected Clip load() throws IOException {
        return this._provider.loadClip(this._path);
    }

    protected boolean bind(Clip clip) {
        this._buffer.setData(clip.format, clip.data, clip.frequency);
        int errno = AL10.alGetError();
        if (errno != 0) {
            Log.log.warning((Object)"Failed to bind clip", new Object[]{"key", this.getKey(), "errno", errno});
            this.failed();
            return false;
        }
        this._state = 2;
        this._size = this._buffer.getSize();
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<Observer>(){

            public boolean apply(Observer observer) {
                observer.clipLoaded(ClipBuffer.this);
                return true;
            }
        });
        this._observers.clear();
        return true;
    }

    protected void failed() {
        if (this._buffer != null) {
            this._buffer.delete();
            this._buffer = null;
        }
        this._state = 0;
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<Observer>(){

            public boolean apply(Observer observer) {
                observer.clipFailed(ClipBuffer.this);
                return true;
            }
        });
        this._observers.clear();
    }

    protected void sourceBound() {
        ++this._bound;
    }

    protected void sourceUnbound() {
        if (--this._bound == 0 && this._state == 3) {
            this.dispose();
        }
    }

    public static interface Observer {
        public void clipLoaded(ClipBuffer var1);

        public void clipFailed(ClipBuffer var1);
    }
}

