/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.util.StringUtil;
import com.threerings.media.tile.NoSuchTileSetException;
import com.threerings.media.tile.ObjectTile;
import com.threerings.media.tile.TileManager;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileUtil;
import com.threerings.miso.Log;
import com.threerings.miso.MisoPrefs;
import com.threerings.miso.client.MisoScenePanel;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class SceneObject {
    public ObjectInfo info;
    public ObjectTile tile;
    public Rectangle bounds;
    protected Rectangle _frect;
    protected Polygon _footprint;
    protected Point _fspot;
    protected Point _sspot;
    protected boolean _warning;
    protected static RuntimeAdjust.BooleanAdjust _hideObjects = new RuntimeAdjust.BooleanAdjust("Toggles rendering of objects in the scene view.", "narya.miso.hide_objects", MisoPrefs.config, false);
    protected static RuntimeAdjust.BooleanAdjust _fprintDebug = new RuntimeAdjust.BooleanAdjust("Toggles rendering of object footprints in the scene view.", "narya.miso.iso_fprint_debug_render", MisoPrefs.config, false);
    protected static Polygon _spotTri = new Polygon();
    protected static final Composite ALPHA_WARN;

    public SceneObject(MisoScenePanel panel, ObjectInfo info) {
        this(panel.getSceneMetrics(), panel.getTileManager(), panel.getColorizer(info), info);
    }

    public SceneObject(MisoSceneMetrics metrics, TileManager mgr, TileSet.Colorizer colorizer, ObjectInfo info) {
        this.info = info;
        this.refreshObjectTile(metrics, mgr, colorizer);
    }

    public SceneObject(MisoScenePanel panel, ObjectInfo info, ObjectTile tile) {
        this(panel.getSceneMetrics(), info, tile);
    }

    public SceneObject(MisoSceneMetrics metrics, ObjectInfo info, ObjectTile tile) {
        this.info = info;
        this.tile = tile;
        this.computeInfo(metrics);
    }

    public void setWarning(boolean warning) {
        this._warning = warning;
    }

    public void paint(Graphics2D gfx) {
        Composite ocomp;
        boolean footpaint = _fprintDebug.getValue();
        if (footpaint) {
            gfx.setColor(Color.black);
            gfx.draw(this._footprint);
            if (_hideObjects.getValue()) {
                ocomp = gfx.getComposite();
                gfx.setComposite(ALPHA_WARN);
                gfx.fill(this._footprint);
                gfx.setComposite(ocomp);
            }
        }
        if (_hideObjects.getValue()) {
            return;
        }
        if (this._warning) {
            ocomp = gfx.getComposite();
            gfx.setComposite(ALPHA_WARN);
            gfx.fill(this.bounds);
            gfx.setComposite(ocomp);
        }
        this.tile.paint(gfx, this.bounds.x, this.bounds.y);
        if (footpaint && this._sspot != null) {
            gfx.translate(this._sspot.x, this._sspot.y);
            double rot = 0.7853981633974483 * (double)this.tile.getSpotOrient();
            gfx.rotate(rot);
            gfx.setColor(Color.green);
            gfx.fill(_spotTri);
            gfx.setColor(Color.black);
            gfx.draw(_spotTri);
            gfx.rotate(-rot);
            gfx.translate(-this._sspot.x, -this._sspot.y);
        }
    }

    public Point getObjectSpot() {
        return this._fspot;
    }

    public Point getObjectScreenSpot() {
        return this._sspot;
    }

    public boolean objectFootprintOverlaps(SceneObject so) {
        return this._frect.intersects(so._frect);
    }

    public boolean objectFootprintOverlaps(Rectangle rect) {
        return this._frect.intersects(rect);
    }

    public Polygon getObjectFootprint() {
        return this._footprint;
    }

    public int getPriority() {
        return this.info.priority == 0 && this.tile != null ? this.tile.getPriority() : this.info.priority;
    }

    public void setPriority(byte priority) {
        this.info.priority = (byte)Math.max(-128, Math.min(127, priority));
    }

    public boolean setHovered(boolean hovered) {
        return false;
    }

    public void relocateObject(MisoSceneMetrics metrics, int tx, int ty) {
        this.info.x = tx;
        this.info.y = ty;
        this.computeInfo(metrics);
    }

    public void refreshObjectTile(MisoScenePanel panel) {
        this.refreshObjectTile(panel.getSceneMetrics(), panel.getTileManager(), panel.getColorizer(this.info));
    }

    public void refreshObjectTile(MisoSceneMetrics metrics, TileManager mgr, TileSet.Colorizer colorizer) {
        int tsid = TileUtil.getTileSetId(this.info.tileId);
        int tidx = TileUtil.getTileIndex(this.info.tileId);
        try {
            this.tile = (ObjectTile)mgr.getTile(tsid, tidx, colorizer);
            this.computeInfo(metrics);
        }
        catch (NoSuchTileSetException te) {
            Log.log.warning((Object)("Scene contains non-existent object tileset [info=" + this.info + "]."), new Object[0]);
        }
    }

    protected void computeInfo(MisoSceneMetrics metrics) {
        Point tpos = MisoUtil.tileToScreen(metrics, this.info.x, this.info.y, new Point());
        int tox = this.tile.getOriginX();
        int toy = this.tile.getOriginY();
        if (tox == Integer.MIN_VALUE) {
            tox = this.tile.getBaseWidth() * metrics.tilehwid;
        }
        if (toy == Integer.MIN_VALUE) {
            toy = this.tile.getHeight();
        }
        this.bounds = new Rectangle(tpos.x + metrics.tilehwid - tox, tpos.y + metrics.tilehei - toy, this.tile.getWidth(), this.tile.getHeight());
        this._frect = new Rectangle(this.info.x - this.tile.getBaseWidth() + 1, this.info.y - this.tile.getBaseHeight() + 1, this.tile.getBaseWidth(), this.tile.getBaseHeight());
        this._footprint = MisoUtil.getFootprintPolygon(metrics, this._frect.x, this._frect.y, this._frect.width, this._frect.height);
        if (this.tile.hasSpot()) {
            this._fspot = MisoUtil.tilePlusFineToFull(metrics, this.info.x, this.info.y, this.tile.getSpotX(), this.tile.getSpotY(), new Point());
            this._sspot = MisoUtil.fullToScreen(metrics, this._fspot.x, this._fspot.y, new Point());
        }
    }

    public String toString() {
        return this.info + "[" + StringUtil.toString((Object)this.bounds) + "]";
    }

    static {
        _spotTri.addPoint(-3, -3);
        _spotTri.addPoint(3, -3);
        _spotTri.addPoint(0, 3);
        ALPHA_WARN = AlphaComposite.getInstance(3, 0.3f);
    }
}

