/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.threerings.media.Log;
import com.threerings.media.util.DelegatingPathable;
import com.threerings.media.util.Path;
import com.threerings.media.util.Pathable;
import com.threerings.media.util.TimedPath;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathSequence
implements Path {
    protected List<Path> _paths;
    protected long _lastInit;
    protected Path _curPath;
    protected Pathable _pable;
    protected Pathable _pableRep;

    public PathSequence(Path first, Path second) {
        this(new ArrayList<Path>());
        this._paths.add(first);
        this._paths.add(second);
    }

    public PathSequence(List<Path> paths) {
        this._paths = paths;
    }

    public void addPath(Path path) {
        this._paths.add(path);
    }

    @Override
    public void init(Pathable pable, long tickStamp) {
        this._pable = pable;
        this._pableRep = new DelegatingPathable(this._pable){

            public void pathCompleted(long timeStamp) {
                long initStamp = PathSequence.this._curPath instanceof TimedPath ? PathSequence.this._lastInit + ((TimedPath)PathSequence.this._curPath)._duration : timeStamp;
                PathSequence.this.initNextPath(initStamp, timeStamp);
            }
        };
        this.initNextPath(tickStamp, tickStamp);
    }

    @Override
    public boolean tick(Pathable pable, long tickStamp) {
        if (pable != this._pable) {
            Log.log.warning((Object)"PathSequence ticked with different path than it was inited with.", new Object[0]);
        }
        return this._curPath.tick(this._pableRep, tickStamp);
    }

    @Override
    public void fastForward(long timeDelta) {
        this._lastInit += timeDelta;
        this._curPath.fastForward(timeDelta);
    }

    @Override
    public void paint(Graphics2D gfx) {
        this._curPath.paint(gfx);
    }

    @Override
    public void wasRemoved(Pathable pable) {
        if (this._curPath != null) {
            this._curPath.wasRemoved(this._pableRep);
        }
    }

    protected void initNextPath(long initStamp, long tickStamp) {
        if (this._paths.size() == 0) {
            this._pable.pathCompleted(tickStamp);
        } else {
            this._curPath = this._paths.remove(0);
            this._lastInit = initStamp;
            this._curPath.init(this._pableRep, initStamp);
            this._curPath.tick(this._pableRep, tickStamp);
        }
    }
}

