/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tools;

import com.google.common.collect.Lists;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.PrefsConfig;
import com.samskivert.util.QuickSort;
import com.threerings.media.image.ColorPository;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageUtil;
import com.threerings.media.image.tools.xml.ColorPositoryParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class RecolorImage
extends JPanel
implements ActionListener {
    protected BufferedImage _image;
    protected JFileChooser _chooser;
    protected JFileChooser _colChooser;
    protected JTextField _imagePath;
    protected JTextField _colFilePath;
    protected JLabel _oldImage;
    protected JLabel _newImage;
    protected JPanel _colorLabel;
    protected JTextField _source;
    protected JTextField _target;
    protected SliderAndLabel _hueO;
    protected SliderAndLabel _saturationO;
    protected SliderAndLabel _valueO;
    protected SliderAndLabel _hueD;
    protected SliderAndLabel _saturationD;
    protected SliderAndLabel _valueD;
    protected JTextField _status;
    protected JComboBox _classList;
    protected JComboBox _classList1;
    protected JComboBox _classList2;
    protected JComboBox _classList3;
    protected JComboBox _classList4;
    protected JComboBox _colorList1;
    protected JComboBox _colorList2;
    protected JComboBox _colorList3;
    protected JComboBox _colorList4;
    protected JCheckBox _labelColors;
    protected JTabbedPane _tabs;
    protected ColorPository _colRepo;
    protected static final String IMAGE_PATH = "bundles/components/pirate/head/regular/standing.png";
    protected static final String BROWSE_FOR_IMAGE_FILE = "browse_image";
    protected static final String RELOAD_IMAGE = "reload_image";
    protected static final String BROWSE_FOR_COLORIZATION_FILE = "browse_colorize";
    protected static final String SAVE_COLORIZED_IMAGE = "save_colorized";
    protected static final String UPDATE_TARGET_COLOR = "update_target";
    protected static final String CONVERT = "convert";
    protected static final PrefsConfig CONFIG = new PrefsConfig("rsrc/config/threerings/recolorimage");
    protected static final String NONE = "<none>";
    protected static final String LAST_IMAGE_KEY = "last_image";
    protected static final String LAST_COLORIZATION_KEY = "last_colorization";

    public RecolorImage() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        VGroupLayout vlay = new VGroupLayout(VGroupLayout.STRETCH);
        vlay.setOffAxisPolicy(VGroupLayout.STRETCH);
        this.setLayout((LayoutManager)vlay);
        JPanel images = new JPanel((LayoutManager)new HGroupLayout());
        this._oldImage = new JLabel();
        images.add(this._oldImage);
        this._newImage = new JLabel();
        images.add(this._newImage);
        this.add(new JScrollPane(images));
        JPanel file = new JPanel((LayoutManager)new HGroupLayout(HGroupLayout.STRETCH));
        file.add((Component)new JLabel("Image file:"), HGroupLayout.FIXED);
        this._imagePath = new JTextField();
        file.add(this._imagePath);
        this._imagePath.setEditable(false);
        JButton browse = new JButton("Browse...");
        browse.setActionCommand(BROWSE_FOR_IMAGE_FILE);
        browse.addActionListener(this);
        file.add((Component)browse, HGroupLayout.FIXED);
        JButton reload = new JButton("Reload");
        reload.setActionCommand(RELOAD_IMAGE);
        reload.addActionListener(this);
        file.add((Component)reload, HGroupLayout.FIXED);
        this.add((Component)file, VGroupLayout.FIXED);
        JPanel colFile = new JPanel((LayoutManager)new HGroupLayout(HGroupLayout.STRETCH));
        colFile.add((Component)new JLabel("Colorize file:"), HGroupLayout.FIXED);
        this._colFilePath = new JTextField();
        colFile.add(this._colFilePath);
        this._colFilePath.setEditable(false);
        browse = new JButton("Browse...");
        browse.setActionCommand(BROWSE_FOR_COLORIZATION_FILE);
        browse.addActionListener(this);
        colFile.add((Component)browse, HGroupLayout.FIXED);
        this.add((Component)colFile, VGroupLayout.FIXED);
        this._tabs = new JTabbedPane();
        this._tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                RecolorImage.this.convert();
            }
        });
        this.add((Component)this._tabs, VGroupLayout.FIXED);
        JPanel byFile = new JPanel((LayoutManager)new VGroupLayout(VGroupLayout.STRETCH));
        this._tabs.addTab("Using Color Class", byFile);
        this._classList = new JComboBox();
        byFile.add(this._classList);
        this._labelColors = new JCheckBox("Label Colorizations");
        byFile.add((Component)this._labelColors, VGroupLayout.FIXED);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                RecolorImage.this.convert();
            }
        };
        this._classList.addActionListener(al);
        JPanel multiColor = new JPanel(new GridLayout(4, 2));
        this._tabs.addTab("Multi-Color", multiColor);
        this._classList1 = new JComboBox();
        multiColor.add(this._classList1);
        this._colorList1 = new JComboBox();
        multiColor.add(this._colorList1);
        this._classList2 = new JComboBox();
        multiColor.add(this._classList2);
        this._colorList2 = new JComboBox();
        multiColor.add(this._colorList2);
        this._classList3 = new JComboBox();
        multiColor.add(this._classList3);
        this._colorList3 = new JComboBox();
        multiColor.add(this._colorList3);
        this._classList4 = new JComboBox();
        multiColor.add(this._classList4);
        this._colorList4 = new JComboBox();
        multiColor.add(this._colorList4);
        this._colorList1.addActionListener(al);
        this._colorList2.addActionListener(al);
        this._colorList3.addActionListener(al);
        this._colorList4.addActionListener(al);
        this._labelColors.addActionListener(al);
        JPanel specRecolor = new JPanel((LayoutManager)new VGroupLayout(VGroupLayout.STRETCH));
        this._tabs.addTab("Manual Recolor", specRecolor);
        JPanel controls = new JPanel((LayoutManager)new HGroupLayout(HGroupLayout.STRETCH));
        controls.add((Component)new JLabel("Source color:"), HGroupLayout.FIXED);
        this._source = new JTextField("FF0000");
        controls.add(this._source);
        this._colorLabel = new JPanel();
        this._colorLabel.setSize(48, 48);
        this._colorLabel.setOpaque(true);
        controls.add((Component)this._colorLabel, HGroupLayout.FIXED);
        controls.add((Component)new JLabel("Target color:"), HGroupLayout.FIXED);
        this._target = new JTextField();
        controls.add(this._target);
        JButton update = new JButton("Update");
        update.setActionCommand(UPDATE_TARGET_COLOR);
        update.addActionListener(this);
        controls.add((Component)update, HGroupLayout.FIXED);
        specRecolor.add((Component)controls, VGroupLayout.FIXED);
        HGroupLayout hlay = new HGroupLayout(HGroupLayout.STRETCH);
        JPanel dists = new JPanel((LayoutManager)hlay);
        dists.add((Component)new JLabel("HSV distances:"), HGroupLayout.FIXED);
        this._hueD = new SliderAndLabel(0.0f, 1.0f, 0.05f);
        dists.add(this._hueD);
        this._saturationD = new SliderAndLabel(0.0f, 1.0f, 0.8f);
        dists.add(this._saturationD);
        this._valueD = new SliderAndLabel(0.0f, 1.0f, 0.6f);
        dists.add(this._valueD);
        specRecolor.add((Component)dists, VGroupLayout.FIXED);
        hlay = new HGroupLayout(HGroupLayout.STRETCH);
        JPanel offsets = new JPanel((LayoutManager)hlay);
        offsets.add((Component)new JLabel("HSV offsets:"), HGroupLayout.FIXED);
        this._hueO = new SliderAndLabel(-1.0f, 1.0f, 0.1f);
        offsets.add(this._hueO);
        this._saturationO = new SliderAndLabel(-1.0f, 1.0f, 0.0f);
        offsets.add(this._saturationO);
        this._valueO = new SliderAndLabel(-1.0f, 1.0f, 0.0f);
        offsets.add(this._valueO);
        specRecolor.add((Component)offsets, VGroupLayout.FIXED);
        this._status = new JTextField();
        this.add((Component)this._status, VGroupLayout.FIXED);
        this._status.setEditable(false);
        hlay = new HGroupLayout();
        hlay.setJustification(HGroupLayout.CENTER);
        JPanel buttons = new JPanel((LayoutManager)hlay);
        JButton button = new JButton("Convert");
        button.setActionCommand(CONVERT);
        button.addActionListener(this);
        buttons.add(button);
        button = new JButton("Save Snapshot");
        button.setActionCommand(SAVE_COLORIZED_IMAGE);
        button.addActionListener(this);
        buttons.add(button);
        this.add((Component)buttons, VGroupLayout.FIXED);
        images.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                RecolorImage.this.mousePressed(event);
            }
        });
        String cwd = System.getProperty("user.dir");
        String image = CONFIG.getValue(LAST_IMAGE_KEY, cwd);
        String colorization = CONFIG.getValue(LAST_COLORIZATION_KEY, cwd);
        this._chooser = new JFileChooser(image);
        this._colChooser = new JFileChooser(colorization);
    }

    protected void convert() {
        if (this._image == null) {
            return;
        }
        try {
            BufferedImage image;
            if (this._tabs.getSelectedIndex() == 0) {
                image = this.getAllRecolors(this._labelColors.isSelected());
                if (image == null) {
                    return;
                }
            } else if (this._tabs.getSelectedIndex() == 1) {
                ArrayList zations = Lists.newArrayList();
                if (this._classList1.getSelectedItem() != NONE) {
                    zations.add(this._colRepo.getColorization((String)this._classList1.getSelectedItem(), (String)this._colorList1.getSelectedItem()));
                }
                if (this._classList2.getSelectedItem() != NONE) {
                    zations.add(this._colRepo.getColorization((String)this._classList2.getSelectedItem(), (String)this._colorList2.getSelectedItem()));
                }
                if (this._classList3.getSelectedItem() != NONE) {
                    zations.add(this._colRepo.getColorization((String)this._classList3.getSelectedItem(), (String)this._colorList3.getSelectedItem()));
                }
                if (this._classList4.getSelectedItem() != NONE) {
                    zations.add(this._colRepo.getColorization((String)this._classList4.getSelectedItem(), (String)this._colorList4.getSelectedItem()));
                }
                image = ImageUtil.recolorImage(this._image, zations.toArray(new Colorization[zations.size()]));
            } else {
                int color = Integer.parseInt(this._source.getText(), 16);
                float hueD = this._hueD.getValue();
                float satD = this._saturationD.getValue();
                float valD = this._valueD.getValue();
                float[] dists = new float[]{hueD, satD, valD};
                float hueO = this._hueO.getValue();
                float satO = this._saturationO.getValue();
                float valO = this._valueO.getValue();
                float[] offsets = new float[]{hueO, satO, valO};
                image = ImageUtil.recolorImage(this._image, new Color(color), dists, offsets);
            }
            this._newImage.setIcon(new ImageIcon(image));
            this._status.setText("Recolored image.");
            this.repaint();
        }
        catch (NumberFormatException nfe) {
            this._status.setText("Invalid value: " + nfe.getMessage());
        }
    }

    public BufferedImage getAllRecolors(boolean label) {
        if (this._colRepo == null) {
            return null;
        }
        ColorPository.ClassRecord colClass = this._colRepo.getClassRecord((String)this._classList.getSelectedItem());
        int classId = colClass.classId;
        BufferedImage img = new BufferedImage(this._image.getWidth(), this._image.getHeight() * colClass.colors.size(), 2);
        Graphics gfx = img.getGraphics();
        gfx.setColor(Color.BLACK);
        int y = 0;
        Object[] sortedKeys = colClass.colors.keySet().toArray(new Integer[colClass.colors.size()]);
        Arrays.sort(sortedKeys);
        Object[] arr$ = sortedKeys;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int key = (Integer)arr$[i$];
            Colorization coloriz = this._colRepo.getColorization(classId, key);
            BufferedImage subImg = ImageUtil.recolorImage(this._image, coloriz.rootColor, coloriz.range, coloriz.offsets);
            gfx.drawImage(subImg, 0, y, null, null);
            if (label) {
                ColorPository.ColorRecord crec = this._colRepo.getColorRecord(classId, key);
                gfx.drawString(crec.name, 2, y + gfx.getFontMetrics().getHeight() + 2);
                gfx.drawRect(0, y, this._image.getWidth() - 1, this._image.getHeight());
            }
            y += subImg.getHeight();
        }
        return img;
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(CONVERT)) {
            this.convert();
        } else if (cmd.equals(UPDATE_TARGET_COLOR)) {
            try {
                int source = Integer.parseInt(this._source.getText(), 16);
                int target = Integer.parseInt(this._target.getText(), 16);
                float[] shsv = RecolorImage.rgbToHSV(source);
                float[] thsv = RecolorImage.rgbToHSV(target);
                this._hueO.setValue(thsv[0] - shsv[0]);
                this._saturationO.setValue(thsv[1] - shsv[1]);
                this._valueO.setValue(thsv[2] - shsv[2]);
            }
            catch (NumberFormatException nfe) {
                this._status.setText("Invalid value: " + nfe.getMessage());
            }
        } else if (cmd.equals(BROWSE_FOR_IMAGE_FILE)) {
            int result = this._chooser.showOpenDialog(this);
            if (result == 0) {
                this.setImage(this._chooser.getSelectedFile());
            }
        } else if (cmd.equals(RELOAD_IMAGE)) {
            this.setImage(this._chooser.getSelectedFile());
        } else if (cmd.equals(BROWSE_FOR_COLORIZATION_FILE)) {
            int result = this._colChooser.showOpenDialog(this);
            if (result == 0) {
                this.setColorizeFile(this._colChooser.getSelectedFile());
            }
        } else if (cmd.equals(SAVE_COLORIZED_IMAGE)) {
            JFileChooser chooser = new JFileChooser(this._chooser.getSelectedFile());
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".png");
                }

                public String getDescription() {
                    return "PNG Files";
                }
            });
            int result = chooser.showSaveDialog(this);
            if (result == 0) {
                try {
                    ImageIO.write((RenderedImage)((BufferedImage)((ImageIcon)this._newImage.getIcon()).getImage()), "png", chooser.getSelectedFile());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Error while saving image: " + e.getMessage(), "Error Saving Image", 0);
                }
            }
        }
    }

    public void setImage(File path) {
        try {
            this._image = ImageIO.read(path);
            this._imagePath.setText(path.getPath());
            this._oldImage.setIcon(new ImageIcon(this._image));
            CONFIG.setValue(LAST_IMAGE_KEY, path.getAbsolutePath());
        }
        catch (IOException ioe) {
            this._status.setText("Error opening image file: " + ioe);
        }
    }

    public void setupColors(JComboBox box, String className) {
        box.removeAllItems();
        if (className != null && className != NONE) {
            ColorPository.ClassRecord classRec = this._colRepo.getClassRecord(className);
            ArrayList colorNames = Lists.newArrayList();
            for (ColorPository.ColorRecord color : classRec.colors.values()) {
                colorNames.add(color.name);
            }
            QuickSort.sort((List)colorNames);
            for (String colorName : colorNames) {
                box.addItem(colorName);
            }
        }
    }

    public void setColorizeFile(File path) {
        try {
            if (path.getName().endsWith("xml")) {
                ColorPositoryParser parser = new ColorPositoryParser();
                this._colRepo = (ColorPository)parser.parseConfig(path);
            } else {
                this._colRepo = ColorPository.loadColorPository(new FileInputStream(path));
            }
            this._classList.removeAllItems();
            this._classList1.removeAllItems();
            this._classList1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    RecolorImage.this.setupColors(RecolorImage.this._colorList1, (String)RecolorImage.this._classList1.getSelectedItem());
                }
            });
            this._classList2.removeAllItems();
            this._classList2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    RecolorImage.this.setupColors(RecolorImage.this._colorList2, (String)RecolorImage.this._classList2.getSelectedItem());
                }
            });
            this._classList3.removeAllItems();
            this._classList3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    RecolorImage.this.setupColors(RecolorImage.this._colorList3, (String)RecolorImage.this._classList3.getSelectedItem());
                }
            });
            this._classList4.removeAllItems();
            this._classList4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    RecolorImage.this.setupColors(RecolorImage.this._colorList4, (String)RecolorImage.this._classList4.getSelectedItem());
                }
            });
            Iterator<ColorPository.ClassRecord> iter = this._colRepo.enumerateClasses();
            ArrayList names = Lists.newArrayList();
            while (iter.hasNext()) {
                String str = iter.next().name;
                names.add(str);
            }
            this._classList1.addItem(NONE);
            this._classList2.addItem(NONE);
            this._classList3.addItem(NONE);
            this._classList4.addItem(NONE);
            Collections.sort(names);
            for (String name : names) {
                this._classList.addItem(name);
                this._classList1.addItem(name);
                this._classList2.addItem(name);
                this._classList3.addItem(name);
                this._classList4.addItem(name);
            }
            this._classList.setSelectedIndex(0);
            this._classList1.setSelectedIndex(0);
            this._classList2.setSelectedIndex(0);
            this._classList3.setSelectedIndex(0);
            this._classList4.setSelectedIndex(0);
            this._colFilePath.setText(path.getPath());
            CONFIG.setValue(LAST_COLORIZATION_KEY, path.getAbsolutePath());
        }
        catch (Exception ex) {
            this._status.setText("Error opening colorization file: " + ex);
        }
    }

    protected static float[] rgbToHSV(int rgb) {
        float[] hsv = new float[3];
        Color color = new Color(rgb);
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsv);
        return hsv;
    }

    public void mousePressed(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        Rectangle ibounds = this._oldImage.getBounds();
        if (ibounds.contains(x, y)) {
            int argb = this._image.getRGB(x - ibounds.x, y - ibounds.y);
            String cstr = Integer.toString(argb & 0xFFFFFF, 16);
            this._source.setText(cstr.toUpperCase());
            this._colorLabel.setBackground(new Color(argb));
            this._colorLabel.repaint();
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame("Image recoloring test");
            frame.setDefaultCloseOperation(3);
            RecolorImage panel = new RecolorImage();
            if (args.length > 0) {
                panel.setImage(new File(args[0]));
            }
            frame.getContentPane().add((Component)panel, "Center");
            frame.setSize(600, 600);
            SwingUtil.centerWindow((Window)frame);
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    protected class SliderAndLabel
    extends JPanel {
        protected JSlider _slider;
        protected JLabel _intField;
        protected static final float CONVERSION = 1000.0f;

        public SliderAndLabel(float minf, float maxf, float valuef) {
            int min = (int)(minf * 1000.0f);
            int max = (int)(maxf * 1000.0f);
            int value = (int)(valuef * 1000.0f);
            this.setLayout((LayoutManager)new VGroupLayout(VGroupLayout.STRETCH));
            this._intField = new JLabel(String.valueOf((float)value / 1000.0f));
            this._slider = new JSlider(min, max, value);
            this._slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    SliderAndLabel.this._intField.setText(String.valueOf((float)SliderAndLabel.this._slider.getValue() / 1000.0f));
                    RecolorImage.this.convert();
                }
            });
            this.add(this._intField);
            this.add(this._slider);
        }

        public float getValue() {
            return (float)this._slider.getValue() / 1000.0f;
        }

        public void setValue(float val) {
            this._slider.setValue((int)(val * 1000.0f));
        }
    }
}

