/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.timer;

import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.util.Interval;
import com.samskivert.util.Logger;
import com.threerings.media.MediaPrefs;
import com.threerings.media.timer.MediaTimer;

public abstract class CalibratingTimer
implements MediaTimer {
    protected long _startStamp;
    protected long _priorCurrent;
    protected long _milliDivider;
    protected long _microDivider;
    protected long _driftMilliStamp = System.currentTimeMillis();
    protected long _driftTimerStamp;
    protected float _driftRatio = 1.0f;
    protected float _maxDriftRatio = 1.0f;
    protected Interval _calibrateInterval;
    protected final Logger log = Logger.getLogger(CalibratingTimer.class);
    protected static final float MAX_ALLOWED_DRIFT_RATIO = 1.1f;
    protected static final float MIN_ALLOWED_DRIFT_RATIO = 0.9f;
    protected static final int CALIBRATE_INTERVAL = 5000;
    protected static RuntimeAdjust.BooleanAdjust _debugCalibrate = new RuntimeAdjust.BooleanAdjust("Toggles calibrations statistics", "narya.media.timer", MediaPrefs.config, false);

    protected void init(long milliDivider, long microDivider) {
        this._milliDivider = milliDivider;
        this._microDivider = microDivider;
        this.reset();
        this.log.info((Object)("Using " + this.getClass() + " timer"), new Object[]{"mfreq", this._milliDivider, "ufreq", this._microDivider, "start", this._startStamp});
    }

    public long getElapsedMicros() {
        return this.elapsed() / this._microDivider;
    }

    public long getElapsedMillis() {
        return this.elapsed() / this._milliDivider;
    }

    public void reset() {
        if (this._calibrateInterval != null) {
            this._calibrateInterval.cancel();
            this._calibrateInterval = null;
        }
        this._startStamp = this._priorCurrent = this.current();
        this._driftMilliStamp = System.currentTimeMillis();
        this._driftTimerStamp = this.current();
        this._calibrateInterval = new Interval(){

            public void expired() {
                CalibratingTimer.this.calibrate();
            }
        };
        this._calibrateInterval.schedule(5000L, 5000L, false);
    }

    public abstract long current();

    public float getMaxDriftRatio() {
        return this._maxDriftRatio;
    }

    public void clearMaxDriftRatio() {
        this._maxDriftRatio = 1.0f;
    }

    protected long elapsed() {
        long current = this.current();
        if ((double)this._driftRatio != 1.0) {
            long elapsed = current - this._priorCurrent;
            this._startStamp = (long)((float)this._startStamp + ((float)elapsed - (float)elapsed * this._driftRatio));
        }
        this._priorCurrent = current;
        return current - this._startStamp;
    }

    protected void calibrate() {
        long currentTimer = this.current();
        long currentMillis = System.currentTimeMillis();
        long elapsedTimer = currentTimer - this._driftTimerStamp;
        float elapsedMillis = currentMillis - this._driftMilliStamp;
        float drift = elapsedMillis / (float)(elapsedTimer / this._milliDivider);
        if (_debugCalibrate.getValue()) {
            this.log.warning((Object)"Calibrating", new Object[]{"timer", elapsedTimer, "millis", Float.valueOf(elapsedMillis), "drift", Float.valueOf(drift), "timerstamp", this._driftTimerStamp, "millistamp", this._driftMilliStamp, "current", currentTimer});
        }
        if (elapsedTimer < 0L) {
            this.log.warning((Object)"The timer has decided to live in the past, resetting drift", new Object[]{"previousTimer", this._driftTimerStamp, "currentTimer", currentTimer, "previousMillis", this._driftMilliStamp, "currentMillis", currentMillis});
            this._driftRatio = 1.0f;
        } else if (drift > 1.1f || drift < 0.9f) {
            this.log.warning((Object)"Calibrating", new Object[]{"drift", Float.valueOf(drift)});
            this._driftRatio = drift < 110.0f && drift > 0.009f ? drift : 1.0f;
            if (Math.abs((double)drift - 1.0) > Math.abs((double)this._maxDriftRatio - 1.0)) {
                this._maxDriftRatio = drift;
            }
        } else if ((double)this._driftRatio != 1.0) {
            this.log.warning((Object)"Calibrating", new Object[]{"drift", Float.valueOf(drift)});
            this._driftRatio = 1.0f;
        }
        this._driftMilliStamp = currentMillis;
        this._driftTimerStamp = currentTimer;
    }
}

