/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.bundle.tools;

import com.samskivert.io.StreamUtil;
import com.threerings.media.Log;
import com.threerings.media.tile.ImageProvider;
import com.threerings.media.tile.ObjectTileSet;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TrimmedObjectTileSet;
import com.threerings.media.tile.bundle.TileSetBundle;
import com.threerings.media.tile.bundle.tools.TileSetBundler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class DirectoryTileSetBundler
extends TileSetBundler {
    public DirectoryTileSetBundler(File configFile) throws IOException {
        super(configFile);
    }

    public DirectoryTileSetBundler(String configPath) throws IOException {
        super(configPath);
    }

    public boolean createBundle(File target, TileSetBundle bundle, ImageProvider improv, String imageBase, long newestMod) throws IOException {
        try {
            Iterator<Integer> iditer = bundle.enumerateTileSetIds();
            while (iditer.hasNext()) {
                int tileSetId = iditer.next();
                TileSet set = bundle.getTileSet(tileSetId);
                String imagePath = set.getImagePath();
                if (imagePath == null) {
                    Log.log.warning((Object)("Tileset contains no image path [set=" + set + "]. It ain't gonna work."), new Object[0]);
                    continue;
                }
                if (set instanceof ObjectTileSet) {
                    set.setImageProvider(improv);
                    try {
                        File outFile = new File(target, imagePath);
                        FileOutputStream fout = null;
                        if (outFile.lastModified() <= newestMod) {
                            outFile.getParentFile().mkdirs();
                            fout = new FileOutputStream(outFile);
                        }
                        TrimmedObjectTileSet tset = TrimmedObjectTileSet.trimObjectTileSet((ObjectTileSet)set, fout, "png");
                        tset.setImagePath(imagePath);
                        bundle.addTileSet(tileSetId, tset);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        String msg = "Error adding tileset to bundle " + imagePath + ", " + set.getName() + ": " + e;
                        throw (IOException)new IOException(msg).initCause(e);
                    }
                }
                File ifile = new File(imageBase, imagePath);
                if (ifile.lastModified() > newestMod) continue;
                try {
                    ImageIO.read(ifile);
                    File outFile = new File(target, imagePath);
                    if (outFile.lastModified() > newestMod) continue;
                    outFile.getParentFile().mkdirs();
                    FileOutputStream fout = new FileOutputStream(outFile);
                    FileInputStream imgin = new FileInputStream(ifile);
                    StreamUtil.copy((InputStream)imgin, (OutputStream)fout);
                }
                catch (Exception e) {
                    String msg = "Failure bundling image " + ifile + ": " + e;
                    throw (IOException)new IOException(msg).initCause(e);
                }
            }
            File outFile = new File(target, "tsbundles.dat");
            outFile.getParentFile().mkdirs();
            FileOutputStream fout = new FileOutputStream(outFile);
            ObjectOutputStream oout = new ObjectOutputStream(fout);
            oout.writeObject(bundle);
            oout.flush();
            return true;
        }
        catch (Exception e) {
            String errmsg = "Failed to create bundle " + target + ": " + e;
            throw (IOException)new IOException(errmsg).initCause(e);
        }
    }

    protected boolean skipIfTargetNewer() {
        return false;
    }
}

