/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile;

import com.google.common.collect.Maps;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Throttle;
import com.threerings.media.Log;
import com.threerings.media.image.BufferedMirage;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageUtil;
import com.threerings.media.image.Mirage;
import com.threerings.media.tile.ImageProvider;
import com.threerings.media.tile.Tile;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Map;

public abstract class TileSet
implements Cloneable,
Serializable {
    protected String _imagePath;
    protected String _name;
    protected transient Colorization[] _zations;
    protected transient ImageProvider _improv;
    private static final long serialVersionUID = 1L;
    protected static Map<Tile.Key, SoftReference<Tile>> _atiles = Maps.newHashMap();
    protected static Tile.Key _key = new Tile.Key(null, 0, null);
    protected static Throttle _cacheStatThrottle = new Throttle(1, 300000L);

    public void setImageProvider(ImageProvider improv) {
        this._improv = improv;
    }

    public String getName() {
        return this._name == null ? this._imagePath : this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setImagePath(String imagePath) {
        this._imagePath = imagePath;
    }

    public String getImagePath() {
        return this._imagePath;
    }

    public abstract int getTileCount();

    public TileSet clone(Colorization[] zations) {
        try {
            TileSet tset = (TileSet)this.clone();
            tset._zations = zations;
            return tset;
        }
        catch (CloneNotSupportedException cnse) {
            Log.log.warning((Object)("Unable to clone tileset prior to colorization [tset=" + this + ", zations=" + StringUtil.toString((Object)zations) + ", error=" + cnse + "]."), new Object[0]);
            return null;
        }
    }

    public TileSet clone(String imagePath) throws CloneNotSupportedException {
        TileSet dup = (TileSet)this.clone();
        dup.setImagePath(imagePath);
        return dup;
    }

    public abstract Rectangle computeTileBounds(int var1, Rectangle var2);

    public Tile getTile(int tileIndex) {
        return this.getTile(tileIndex, this._zations);
    }

    public Tile getTile(int tileIndex, Colorizer rizer) {
        return this.getTile(tileIndex, this.getColorizations(tileIndex, rizer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tile getTile(int tileIndex, Colorization[] zations) {
        Tile tile = null;
        Map<Tile.Key, SoftReference<Tile>> map = _atiles;
        synchronized (map) {
            TileSet._key.tileSet = this;
            TileSet._key.tileIndex = tileIndex;
            TileSet._key.zations = zations;
            SoftReference<Tile> sref = _atiles.get(_key);
            if (sref != null) {
                tile = sref.get();
            }
        }
        if (tile == null) {
            tile = this.createTile();
            tile.key = new Tile.Key(this, tileIndex, zations);
            this.initTile(tile, tileIndex, zations);
            map = _atiles;
            synchronized (map) {
                _atiles.put(tile.key, new SoftReference<Tile>(tile));
            }
        }
        this.reportCachePerformance();
        return tile;
    }

    public Mirage getTileMirage(int tileIndex) {
        return this.getTileMirage(tileIndex, this.getColorizations(tileIndex, null));
    }

    public Mirage[] getTileMirages() {
        Mirage[] mirages = new Mirage[this.getTileCount()];
        for (int ii = 0; ii < mirages.length; ++ii) {
            mirages[ii] = this.getTileMirage(ii);
        }
        return mirages;
    }

    public Mirage getTileMirage(int tileIndex, Colorization[] zations) {
        Rectangle bounds = this.computeTileBounds(tileIndex, new Rectangle());
        Mirage mirage = null;
        if (this.checkTileIndex(tileIndex)) {
            if (this._improv == null) {
                Log.log.warning((Object)("Aiya! Tile set missing image provider [path=" + this._imagePath + "]."), new Object[0]);
            } else {
                mirage = this._improv.getTileImage(this._imagePath, bounds, zations);
            }
        }
        if (mirage == null) {
            mirage = new BufferedMirage(ImageUtil.createErrorImage(bounds.width, bounds.height));
        }
        return mirage;
    }

    public BufferedImage getRawTileSetImage() {
        return this._improv.getTileSetImage(this._imagePath, this._zations);
    }

    public BufferedImage getRawTileImage(int tileIndex) {
        Rectangle bounds = this.computeTileBounds(tileIndex, new Rectangle());
        BufferedImage img = null;
        if (this.checkTileIndex(tileIndex)) {
            BufferedImage timg = this.getRawTileSetImage();
            if (timg != null) {
                img = timg.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
            } else {
                Log.log.warning((Object)("Missing source image " + this), new Object[0]);
            }
        }
        if (img == null) {
            img = ImageUtil.createErrorImage(bounds.width, bounds.height);
        }
        return img;
    }

    protected Colorization[] getColorizations(int tileIndex, Colorizer rizer) {
        return this._zations;
    }

    protected boolean checkTileIndex(int tileIndex) {
        int tcount = this.getTileCount();
        if (tileIndex >= 0 && tileIndex < tcount) {
            return true;
        }
        Log.log.warning((Object)("Requested invalid tile [tset=" + this + ", index=" + tileIndex + "]."), new Object[]{new Exception()});
        return false;
    }

    protected Tile createTile() {
        return new Tile();
    }

    protected void initTile(Tile tile, int tileIndex, Colorization[] zations) {
        if (this._improv != null) {
            tile.setImage(this.getTileMirage(tileIndex, zations));
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        this.toString(buf);
        return buf.append("]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportCachePerformance() {
        if (this._improv == null || _cacheStatThrottle.throttleOp()) {
            return;
        }
        long amem = 0L;
        int asize = 0;
        Map<Tile.Key, SoftReference<Tile>> map = _atiles;
        synchronized (map) {
            for (SoftReference<Tile> sref : _atiles.values()) {
                Tile tile = sref.get();
                if (tile == null) continue;
                ++asize;
                amem += tile.getEstimatedMemoryUsage();
            }
        }
        Log.log.info((Object)("Tile caches [amem=" + amem / 1024L + "k" + ", tmem=" + Tile._totalTileMemory / 1024L + "k" + ", seen=" + _atiles.size() + ", asize=" + asize + "]."), new Object[0]);
    }

    protected void toString(StringBuilder buf) {
        buf.append("name=").append(this._name);
        buf.append(", path=").append(this._imagePath);
    }

    public static interface Colorizer {
        public Colorization getColorization(int var1, String var2);
    }
}

