/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile;

import com.samskivert.util.LRUHashMap;
import com.threerings.media.Log;
import com.threerings.media.image.BufferedMirage;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageUtil;
import com.threerings.media.image.Mirage;
import com.threerings.media.tile.ImageProvider;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;

public abstract class SimpleCachingImageProvider
implements ImageProvider {
    protected Map<String, BufferedImage> _cache = new LRUHashMap(10);

    public BufferedImage getTileSetImage(String path, Colorization[] zations) {
        BufferedImage image = this._cache.get(path);
        if (image == null) {
            try {
                image = this.loadImage(path);
                this._cache.put(path, image);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Failed to load image [path=" + path + ", ioe=" + ioe + "]."), new Object[0]);
            }
        }
        if (zations == null || image == null) {
            return image;
        }
        return ImageUtil.recolorImage(image, zations);
    }

    public Mirage getTileImage(String path, Rectangle bounds, Colorization[] zations) {
        BufferedImage tsimg = this.getTileSetImage(path, zations);
        tsimg = tsimg.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
        return new BufferedMirage(tsimg);
    }

    protected abstract BufferedImage loadImage(String var1) throws IOException;
}

