/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.threerings.media.animation.Animation;
import com.threerings.media.image.Mirage;
import com.threerings.media.util.LinearTimeFunction;
import com.threerings.media.util.TimeFunction;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class BlendAnimation
extends Animation {
    protected Mirage[] _images;
    protected TimeFunction _tfunc;
    protected int _level;
    protected AlphaComposite _currentComp;
    protected AlphaComposite _nextComp;

    public BlendAnimation(int x, int y, Mirage[] images, int delay) {
        super(new Rectangle(x, y, images[0].getWidth(), images[0].getHeight()));
        this._images = images;
        int fades = images.length - 1;
        this._tfunc = new LinearTimeFunction(0, 100 * fades, delay * fades);
    }

    public void tick(long timestamp) {
        int level = this._tfunc.getValue(timestamp);
        if (level == this._level) {
            return;
        }
        if (level == 100 * (this._images.length - 1)) {
            this._finished = true;
        }
        this._level = level;
        this.invalidate();
    }

    public void fastForward(long timeDelta) {
        this._tfunc.fastForward(timeDelta);
    }

    public void paint(Graphics2D gfx) {
        int index = this._level / 100;
        float alpha = 1.0f - (float)(this._level % 100) / 100.0f;
        Composite ocomp = gfx.getComposite();
        gfx.setComposite(AlphaComposite.getInstance(3, alpha));
        this._images[index].paint(gfx, this._bounds.x, this._bounds.y);
        if (index < this._images.length - 1) {
            gfx.setComposite(AlphaComposite.getInstance(3, 1.0f - alpha));
            this._images[index + 1].paint(gfx, this._bounds.x, this._bounds.y);
        }
        gfx.setComposite(ocomp);
    }
}

