/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.tools.xml;

import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.StringUtil;
import com.samskivert.xml.SetPropertyFieldsRule;
import com.threerings.cast.ComponentClass;
import com.threerings.util.DirectionUtil;
import java.awt.Color;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSetBase;

public class ClassRuleSet
extends RuleSetBase {
    public static final String CLASS_PATH = "/class";
    protected String _prefix;

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public void addRuleInstances(Digester digester) {
        digester.addObjectCreate(this._prefix + CLASS_PATH, ComponentClass.class.getName());
        SetPropertyFieldsRule rule = new SetPropertyFieldsRule();
        rule.addFieldParser("shadowColor", new SetPropertyFieldsRule.FieldParser(){

            public Object parse(String text) {
                int[] values = StringUtil.parseIntArray((String)text);
                return new Color(values[0], values[1], values[2], values[3]);
            }
        });
        digester.addRule(this._prefix + CLASS_PATH, (Rule)rule);
        String opath = this._prefix + CLASS_PATH + "/override";
        digester.addObjectCreate(opath, ComponentClass.PriorityOverride.class.getName());
        rule = new SetPropertyFieldsRule();
        rule.addFieldParser("orients", new SetPropertyFieldsRule.FieldParser(){

            public Object parse(String text) {
                String[] orients = StringUtil.parseStringArray((String)text);
                ArrayIntSet oset = new ArrayIntSet();
                for (String orient : orients) {
                    oset.add(DirectionUtil.fromShortString(orient));
                }
                return oset;
            }
        });
        digester.addRule(opath, (Rule)rule);
        digester.addSetNext(opath, "addPriorityOverride", ComponentClass.PriorityOverride.class.getName());
    }
}

