/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.bundle.tools;

import com.samskivert.util.HashIntMap;
import com.samskivert.util.StringUtil;
import com.threerings.cast.bundle.BundleUtil;
import com.threerings.resource.FileResourceBundle;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpBundle {
    public static void main(String[] args) {
        if (args.length < 1) {
            String usage = "Usage: DumpBundle bundle.jar [bundle.jar ...]";
            System.err.println(usage);
            System.exit(-1);
        }
        for (String arg : args) {
            File file = new File(arg);
            try {
                FileResourceBundle bundle = new FileResourceBundle(file);
                HashMap actions = (HashMap)BundleUtil.loadObject(bundle, "actions.dat", false);
                DumpBundle.dumpTable("actions: ", actions);
                HashMap actionSets = (HashMap)BundleUtil.loadObject(bundle, "action_sets.dat", false);
                DumpBundle.dumpTable("actionSets: ", actionSets);
                HashMap classes = (HashMap)BundleUtil.loadObject(bundle, "classes.dat", false);
                DumpBundle.dumpTable("classes: ", classes);
                HashIntMap comps = (HashIntMap)BundleUtil.loadObject(bundle, "components.dat", false);
                DumpBundle.dumpTable("components: ", comps);
            }
            catch (Exception e) {
                System.err.println("Error dumping bundle [path=" + arg + ", error=" + e + "].");
                e.printStackTrace();
            }
        }
    }

    protected static void dumpTable(String prefix, Map<?, ?> table) {
        if (table != null) {
            System.out.println(prefix + StringUtil.toString(table.entrySet().iterator()));
        }
    }
}

