/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.bundle.tools;

import com.google.common.collect.Lists;
import com.samskivert.io.PersistenceException;
import com.samskivert.util.ComparableArrayList;
import com.samskivert.util.FileUtil;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.Tuple;
import com.threerings.cast.ComponentIDBroker;
import com.threerings.cast.bundle.tools.ComponentBundlerUtil;
import com.threerings.media.tile.SimpleCachingImageProvider;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TrimmedTileSet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.imageio.ImageIO;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBundlerTask
extends Task {
    protected File _target;
    protected File _mapfile;
    protected File _actionDef;
    protected String _root;
    protected ArrayList<FileSet> _filesets = Lists.newArrayList();
    protected boolean _keepRawPngs;
    protected boolean _uncompressed;
    protected static final String SEP_STR = " := ";
    protected static final String[] AUX_EXTS = new String[]{"_shadow", "_crop"};

    public void setTarget(File target) {
        this._target = target;
    }

    public void setMapfile(File mapfile) {
        this._mapfile = mapfile;
    }

    public void setActiondef(File actiondef) {
        this._actionDef = actiondef;
    }

    public void setRoot(File root) {
        this._root = root.getPath();
    }

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void setKeepRawPngs(boolean keep) {
        this._keepRawPngs = keep;
    }

    public void setUncompressed(boolean uncompressed) {
        this._uncompressed = uncompressed;
    }

    public void execute() throws BuildException {
        Map<String, TileSet> actsets;
        this.ensureSet(this._target, "Must specify the path to the target bundle file via the 'target' attribute.");
        this.ensureSet(this._mapfile, "Must specify the path to the component map file via the 'mapfile' attribute.");
        this.ensureSet(this._actionDef, "Must specify the action sequence definitions via the 'actiondef' attribute.");
        try {
            actsets = ComponentBundlerUtil.parseActionTileSets(this._actionDef);
        }
        catch (FileNotFoundException fnfe) {
            throw new BuildException("Unable to load action definition file [path=" + this._actionDef.getPath() + "].", (Throwable)fnfe);
        }
        catch (Exception e) {
            throw new BuildException("Parsing error.", (Throwable)e);
        }
        HashMapIDBroker broker = this.loadBroker(this._mapfile);
        ArrayList sources = Lists.newArrayList();
        sources.addAll(this._filesets);
        sources.add(this._mapfile);
        sources.add(this._actionDef);
        long newest = this.getNewestDate(sources);
        if (this.skipIfTargetNewer() && newest < this._target.lastModified()) {
            System.out.println(this._target.getPath() + " is up to date.");
            return;
        }
        SimpleCachingImageProvider improv = new SimpleCachingImageProvider(){

            protected BufferedImage loadImage(String path) throws IOException {
                return ImageIO.read(new File(path));
            }
        };
        System.out.println("Generating " + this._target + "...");
        try {
            OutputStream fout = this.createOutputStream(this._target);
            HashIntMap mapping = new HashIntMap();
            for (FileSet fs : this._filesets) {
                String[] srcFiles;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File fromDir = fs.getDir(this.getProject());
                for (String srcFile : srcFiles = ds.getIncludedFiles()) {
                    File cfile = new File(fromDir, srcFile);
                    String[] info = this.decomposePath(cfile.getPath());
                    TileSet aset = actsets.get(info[2]);
                    if (aset == null) {
                        System.err.println("No tileset definition for component action '" + info[2] + "' [class=" + info[0] + ", name=" + info[1] + "].");
                        continue;
                    }
                    aset.setImageProvider(improv);
                    int cid = broker.getComponentID(info[0], info[1]);
                    mapping.put(cid, (Object)new Tuple((Object)info[0], (Object)info[1]));
                    this.processComponent(info, aset, cfile, fout, newest);
                    String action = info[2];
                    String ext = ".png";
                    for (String element : AUX_EXTS) {
                        File afile = new File(FileUtil.resuffix((File)cfile, (String)ext, (String)(element + ext)));
                        if (!afile.exists()) continue;
                        info[2] = action + element;
                        this.processComponent(info, aset, afile, fout, newest);
                    }
                }
            }
            if (!this.skipEntry("components.dat", newest)) {
                fout = this.nextEntry(fout, "components.dat");
                ObjectOutputStream oout = new ObjectOutputStream(fout);
                oout.writeObject(mapping);
                oout.flush();
            }
            if (fout != null) {
                fout.close();
            }
        }
        catch (IOException ioe) {
            String errmsg = "Unable to create component bundle.";
            throw new BuildException(errmsg, (Throwable)ioe);
        }
        catch (PersistenceException pe) {
            String errmsg = "Unable to obtain component ID mapping.";
            throw new BuildException(errmsg, (Throwable)pe);
        }
        this.saveBroker(this._mapfile, broker);
    }

    protected void processComponent(String[] info, TileSet aset, File cfile, OutputStream fout, long newest) throws IOException, BuildException {
        TileSet tset;
        String ipath = this.composePath(info, ".png");
        if (this.skipEntry(ipath, newest)) {
            return;
        }
        fout = this.nextEntry(fout, ipath);
        aset.setImagePath(cfile.getPath());
        if (this._keepRawPngs) {
            try {
                tset = aset;
                BufferedImage image = aset.getRawTileSetImage();
                ImageIO.write((RenderedImage)image, "png", fout);
            }
            catch (Throwable t) {
                System.err.println("Failure storing tileset in jar[class=" + info[0] + ", name=" + info[1] + ", action=" + info[2] + ", srcimg=" + aset.getImagePath() + "].");
                t.printStackTrace(System.err);
                String errmsg = "Failure trimming tileset.";
                throw new BuildException(errmsg, t);
            }
        }
        try {
            tset = this.trim(aset, fout);
            tset.setImagePath(ipath);
        }
        catch (Throwable t) {
            System.err.println("Failure trimming tileset [class=" + info[0] + ", name=" + info[1] + ", action=" + info[2] + ", srcimg=" + aset.getImagePath() + "].");
            t.printStackTrace(System.err);
            String errmsg = "Failure trimming tileset.";
            throw new BuildException(errmsg, t);
        }
        String tpath = this.composePath(info, ".dat");
        if (!this.skipEntry(tpath, newest) && !this._keepRawPngs) {
            fout = this.nextEntry(fout, tpath);
            ObjectOutputStream oout = new ObjectOutputStream(fout);
            oout.writeObject(tset);
            oout.flush();
        }
    }

    protected long getNewestDate(ArrayList<Object> sources) {
        long newest = 0L;
        for (int ii = 0; ii < sources.size(); ++ii) {
            newest = Math.max(newest, this.getNewestDate(sources.get(ii)));
        }
        return newest;
    }

    protected long getNewestDate(Object source) {
        if (source instanceof FileSet) {
            FileSet fs = (FileSet)source;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            long newest = 0L;
            for (String srcFile : srcFiles) {
                File cfile = new File(fromDir, srcFile);
                newest = Math.max(newest, cfile.lastModified());
            }
            return newest;
        }
        if (source instanceof File) {
            return ((File)source).lastModified();
        }
        System.err.println("Can't get newest date for source: " + source + ".");
        return 0L;
    }

    protected boolean skipIfTargetNewer() {
        return true;
    }

    protected String[] decomposePath(String path) throws BuildException {
        if (!path.startsWith(this._root)) {
            throw new BuildException("Can't bundle images outside the root directory [root=" + this._root + ", path=" + path + "].");
        }
        if ((path = path.substring(this._root.length())).startsWith(File.separator)) {
            path = path.substring(1);
        }
        if (!path.endsWith(".png")) {
            throw new BuildException("Can't bundle malformed image file [path=" + path + "].");
        }
        path = path.substring(0, path.length() - ".png".length());
        String malmsg = "Can't decode malformed image path: '" + path + "'";
        String[] info = new String[3];
        int lsidx = path.lastIndexOf(File.separator);
        if (lsidx == -1) {
            throw new BuildException(malmsg);
        }
        info[2] = path.substring(lsidx + 1);
        int slsidx = path.lastIndexOf(File.separator, lsidx - 1);
        if (slsidx == -1) {
            throw new BuildException(malmsg);
        }
        info[1] = path.substring(slsidx + 1, lsidx);
        info[0] = path.substring(0, slsidx);
        info[0].replace(File.separatorChar, '/');
        return info;
    }

    protected String composePath(String[] info, String extension) {
        return info[0] + "/" + info[1] + "/" + info[2] + extension;
    }

    protected void ensureSet(Object value, String errmsg) throws BuildException {
        if (value == null) {
            throw new BuildException(errmsg);
        }
    }

    protected OutputStream createOutputStream(File target) throws IOException {
        JarOutputStream jout = new JarOutputStream(new FileOutputStream(target));
        jout.setLevel(this._uncompressed ? 0 : 9);
        return jout;
    }

    protected OutputStream nextEntry(OutputStream lastEntry, String path) throws IOException {
        ((JarOutputStream)lastEntry).putNextEntry(new JarEntry(path));
        return lastEntry;
    }

    protected boolean skipEntry(String path, long newest) {
        return false;
    }

    protected TrimmedTileSet trim(TileSet aset, OutputStream fout) throws IOException {
        return TrimmedTileSet.trimTileSet(aset, fout);
    }

    protected HashMapIDBroker loadBroker(File mapfile) throws BuildException {
        HashMapIDBroker broker = new HashMapIDBroker();
        try {
            BufferedReader bin = new BufferedReader(new FileReader(mapfile));
            broker.readFrom(bin);
            bin.close();
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (Exception e) {
            throw new BuildException("Error loading component ID map [mapfile=" + mapfile + "]", (Throwable)e);
        }
        return broker;
    }

    protected void saveBroker(File mapfile, ComponentIDBroker broker) throws BuildException {
        HashMapIDBroker hbroker = (HashMapIDBroker)broker;
        if (!hbroker.isModified()) {
            return;
        }
        try {
            BufferedWriter bout = new BufferedWriter(new FileWriter(mapfile));
            hbroker.writeTo(bout);
            bout.close();
        }
        catch (IOException ioe) {
            throw new BuildException("Unable to store component ID map [mapfile=" + mapfile + "]", (Throwable)ioe);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HashMapIDBroker
    extends HashMap<Tuple<String, String>, Integer>
    implements ComponentIDBroker {
        protected int _nextCID = 0;
        protected int _startCID = 0;

        protected HashMapIDBroker() {
        }

        @Override
        public int getComponentID(String cclass, String cname) throws PersistenceException {
            Tuple key = new Tuple((Object)cclass, (Object)cname);
            Integer cid = (Integer)this.get(key);
            if (cid == null) {
                cid = ++this._nextCID;
                this.put(key, cid);
            }
            return cid;
        }

        @Override
        public void commit() throws PersistenceException {
        }

        public boolean isModified() {
            return this._nextCID != this._startCID;
        }

        public void writeTo(BufferedWriter bout) throws IOException {
            String line;
            String cidline = "" + this._nextCID;
            bout.write(cidline, 0, cidline.length());
            bout.newLine();
            ComparableArrayList lines = new ComparableArrayList();
            for (Tuple key : this.keySet()) {
                Integer value = (Integer)this.get(key);
                line = (String)key.left + ComponentBundlerTask.SEP_STR + (String)key.right + ComponentBundlerTask.SEP_STR + value;
                lines.add((Object)line);
            }
            lines.sort();
            int lcount = lines.size();
            for (int ii = 0; ii < lcount; ++ii) {
                line = (String)lines.get(ii);
                bout.write(line, 0, line.length());
                bout.newLine();
            }
        }

        public void readFrom(BufferedReader bin) throws IOException {
            String line;
            this._startCID = this._nextCID = this.readInt(bin);
            while ((line = bin.readLine()) != null) {
                String orig = line;
                int sidx = line.indexOf(ComponentBundlerTask.SEP_STR);
                if (sidx == -1) {
                    throw new IOException("Malformed line '" + orig + "'");
                }
                String cclass = line.substring(0, sidx);
                if ((sidx = (line = line.substring(sidx + ComponentBundlerTask.SEP_STR.length())).indexOf(ComponentBundlerTask.SEP_STR)) == -1) {
                    throw new IOException("Malformed line '" + orig + "'");
                }
                String cname = line.substring(0, sidx);
                line = line.substring(sidx + ComponentBundlerTask.SEP_STR.length());
                try {
                    this.put(new Tuple((Object)cclass, (Object)cname), Integer.valueOf(line));
                }
                catch (NumberFormatException nfe) {
                    String err = "Malformed line, invalid code '" + orig + "'";
                    throw new IOException(err);
                }
            }
        }

        protected int readInt(BufferedReader bin) throws IOException {
            String line = bin.readLine();
            try {
                return Integer.parseInt(line);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Expected number, got '" + line + "'");
            }
        }
    }
}

