/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.tools;

import com.samskivert.io.PersistenceException;
import com.threerings.media.tile.tools.MapFileTileSetIDBroker;
import java.io.File;

public class RenameTileSet {
    public static void renameTileSet(String mapPath, String oldName, String newName) throws PersistenceException {
        MapFileTileSetIDBroker broker = new MapFileTileSetIDBroker(new File(mapPath));
        if (!broker.renameTileSet(oldName, newName)) {
            throw new PersistenceException("No such old tileset '" + oldName + "'.");
        }
        broker.commit();
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: RenameTileSet tileset.map old_name new_name");
            System.exit(-1);
        }
        try {
            RenameTileSet.renameTileSet(args[0], args[1], args[2]);
        }
        catch (PersistenceException pe) {
            System.err.println("Unable to rename tileset: " + (Object)((Object)pe));
            System.exit(-1);
        }
    }
}

