/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamableEnumSet<E extends Enum<E>>
extends AbstractSet<E>
implements Cloneable,
Streamable {
    protected Class<E> _elementType;
    protected byte[] _contents;
    protected int _size;
    protected int _modcount;

    public static <E extends Enum<E>> StreamableEnumSet<E> noneOf(Class<E> elementType) {
        return new StreamableEnumSet<E>(elementType);
    }

    public static <E extends Enum<E>> StreamableEnumSet<E> allOf(Class<E> elementType) {
        StreamableEnumSet<Enum> set = new StreamableEnumSet<Enum>(elementType);
        for (Enum constant : (Enum[])elementType.getEnumConstants()) {
            set.add(constant);
        }
        return set;
    }

    public static <E extends Enum<E>> StreamableEnumSet<E> copyOf(Collection<E> s) {
        if (s instanceof StreamableEnumSet) {
            StreamableEnumSet set = (StreamableEnumSet)s;
            return StreamableEnumSet.copyOf(set);
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException("Collection must have at least one element.");
        }
        StreamableEnumSet<E> set = new StreamableEnumSet<E>(((Enum)s.iterator().next()).getDeclaringClass());
        set.addAll(s);
        return set;
    }

    public static <E extends Enum<E>> StreamableEnumSet<E> copyOf(StreamableEnumSet<E> s) {
        return s.clone();
    }

    public static <E extends Enum<E>> StreamableEnumSet<E> complementOf(StreamableEnumSet<E> s) {
        Class<E> elementType = s._elementType;
        StreamableEnumSet<Enum> set = new StreamableEnumSet<Enum>(elementType);
        for (Enum constant : (Enum[])elementType.getEnumConstants()) {
            if (s.contains(constant)) continue;
            set.add(constant);
        }
        return set;
    }

    public static <E extends Enum<E>> StreamableEnumSet<E> of(E first, E ... rest) {
        StreamableEnumSet<E> set = new StreamableEnumSet<E>(first.getDeclaringClass());
        set.add(first);
        for (E e : rest) {
            set.add(e);
        }
        return set;
    }

    public static <E extends Enum<E>> StreamableEnumSet<E> range(E from, E to) {
        Class<E> elementType = from.getDeclaringClass();
        StreamableEnumSet<Enum> set = new StreamableEnumSet<Enum>(elementType);
        Enum[] constants = (Enum[])elementType.getEnumConstants();
        int last = to.ordinal();
        for (int ii = from.ordinal(); ii <= last; ++ii) {
            set.add(constants[ii]);
        }
        return set;
    }

    public StreamableEnumSet(Class<E> elementType) {
        this._elementType = elementType;
        this.initContents();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            protected int _idx;
            protected int _bit = -1;
            protected int _count;
            protected int _omodcount;
            {
                this._omodcount = StreamableEnumSet.this._modcount;
            }

            @Override
            public boolean hasNext() {
                this.checkConcurrentModification();
                return this._count < StreamableEnumSet.this._size;
            }

            @Override
            public E next() {
                this.checkConcurrentModification();
                do {
                    this._idx += ++this._bit >> 3;
                    this._bit &= 7;
                } while ((StreamableEnumSet.this._contents[this._idx] & 1 << this._bit) == 0);
                ++this._count;
                return ((Enum[])StreamableEnumSet.this._elementType.getEnumConstants())[this._idx << 3 | this._bit];
            }

            @Override
            public void remove() {
                this.checkConcurrentModification();
                int n = this._idx;
                StreamableEnumSet.this._contents[n] = (byte)(StreamableEnumSet.this._contents[n] & ~(1 << this._bit));
                --StreamableEnumSet.this._size;
                --this._count;
                this._omodcount = ++StreamableEnumSet.this._modcount;
            }

            protected void checkConcurrentModification() {
                if (StreamableEnumSet.this._modcount != this._omodcount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean contains(Object o) {
        int mask;
        if (!this._elementType.isInstance(o)) {
            return false;
        }
        int ordinal = ((Enum)o).ordinal();
        int idx = ordinal >> 3;
        return (this._contents[idx] & (mask = 1 << (ordinal & 7))) != 0;
    }

    @Override
    public boolean add(E o) {
        int mask;
        int ordinal = ((Enum)this._elementType.cast(o)).ordinal();
        int idx = ordinal >> 3;
        if ((this._contents[idx] & (mask = 1 << (ordinal & 7))) == 0) {
            int n = idx;
            this._contents[n] = (byte)(this._contents[n] | mask);
            ++this._size;
            ++this._modcount;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        int mask;
        if (!this._elementType.isInstance(o)) {
            return false;
        }
        int ordinal = ((Enum)o).ordinal();
        int idx = ordinal >> 3;
        if ((this._contents[idx] & (mask = 1 << (ordinal & 7))) != 0) {
            int n = idx;
            this._contents[n] = (byte)(this._contents[n] & ~mask);
            --this._size;
            ++this._modcount;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Arrays.fill(this._contents, (byte)0);
        this._size = 0;
        ++this._modcount;
    }

    public StreamableEnumSet<E> clone() {
        try {
            StreamableEnumSet cset = (StreamableEnumSet)super.clone();
            cset._contents = (byte[])this._contents.clone();
            return cset;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        if (!this.classDefinesElementType()) {
            out.writeUTF(this._elementType.getName());
        }
        out.write(this._contents);
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (!this.classDefinesElementType()) {
            Class<?> elementType = Class.forName(in.readUTF());
            this._elementType = elementType;
        } else if (this._elementType == null) {
            throw new RuntimeException("No element type defined in constructor.");
        }
        this.initContents();
        in.read(this._contents);
        for (byte b : this._contents) {
            this._size += Integer.bitCount(b & 0xFF);
        }
    }

    protected boolean classDefinesElementType() {
        return false;
    }

    protected void initContents() {
        int constants;
        this._contents = new byte[(constants >> 3) + (((constants = ((Enum[])this._elementType.getEnumConstants()).length) & 7) == 0 ? 0 : 1)];
    }
}

