/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMap<K, V>
extends ForwardingMap<K, V> {
    protected final Map<K, V> _delegate;
    protected final Function<K, V> _creator;

    public static <K, V> DefaultMap<K, V> newInstanceHashMap(Class<V> clazz) {
        return DefaultMap.newInstanceMap(Maps.newHashMap(), clazz);
    }

    public static <K, V> DefaultMap<K, V> newInstanceMap(Map<K, V> delegate, Class<V> clazz) {
        Function<K, V> creator = DefaultMap.newInstanceCreator(clazz);
        return DefaultMap.newMap(delegate, creator);
    }

    public static <K, V> Function<K, V> newInstanceCreator(Class<V> clazz) {
        Constructor<V> ctor;
        try {
            ctor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException(clazz + " must have a no-args constructor.");
        }
        return new Function<K, V>(){

            public V apply(K key) {
                try {
                    return ctor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static <K, V> DefaultMap<K, V> newHashMap(Function<K, V> creator) {
        return DefaultMap.newMap(Maps.newHashMap(), creator);
    }

    public static <K, V> DefaultMap<K, V> newMap(Map<K, V> delegate, Function<K, V> creator) {
        return new DefaultMap<K, V>(delegate, creator);
    }

    public V fetch(K key) {
        Object value = this.get(key);
        if (value == null && !this.containsKey(key)) {
            value = this._creator.apply(key);
            this.put(key, value);
        }
        return (V)value;
    }

    protected DefaultMap(Map<K, V> delegate, Function<K, V> creator) {
        this._delegate = delegate;
        this._creator = creator;
    }

    protected Map<K, V> delegate() {
        return this._delegate;
    }
}

