/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeneratedSourceMerger {
    protected final Pattern _sectionDelimiter = Pattern.compile(" *// GENERATED (\\w+) (START|END|DISABLED)\n");

    public String merge(String newlyGenerated, String previouslyGenerated) throws Exception {
        LinkedHashMap sections = Maps.newLinkedHashMap();
        Matcher m = this._sectionDelimiter.matcher(newlyGenerated);
        while (m.find()) {
            Section section = this.extractGeneratedSection(m, newlyGenerated);
            Preconditions.checkArgument((!sections.containsKey(section.name) ? 1 : 0) != 0, (String)"Section '%s' used more than once", (Object[])new Object[]{section.name});
            sections.put(section.name, section);
        }
        StringBuilder merged = new StringBuilder();
        m = this._sectionDelimiter.matcher(previouslyGenerated);
        int currentStart = 0;
        while (m.find()) {
            merged.append(previouslyGenerated.substring(currentStart, m.start()));
            Section existingSection = this.extractGeneratedSection(m, previouslyGenerated);
            Section newSection = (Section)sections.remove(existingSection.name);
            if (newSection == null) {
                System.err.println("Dropping previously generated section '" + m.group(1) + "' that's no longer generated by the template");
            } else if (existingSection.disabled) {
                merged.append(existingSection.contents);
            } else {
                merged.append(newSection.contents);
            }
            currentStart = m.end();
        }
        for (Section newSection : sections.values()) {
            System.err.println("Adding previously missing generated section '" + newSection.name + "' before the last non-generated text");
            merged.append(newSection.contents);
        }
        merged.append(previouslyGenerated.substring(currentStart));
        return merged.toString();
    }

    protected Section extractGeneratedSection(Matcher m, String input) {
        int startIdx = m.start();
        String name = m.group(1);
        if (m.group(2).equals("DISABLED")) {
            return new Section(name, input.substring(startIdx, m.end()), true);
        }
        Preconditions.checkArgument((boolean)m.group(2).equals("START"), (String)"'%s' END without START", (Object[])new Object[]{name});
        Preconditions.checkArgument((boolean)m.find(), (String)"'%s' START without END", (Object[])new Object[]{name});
        String endName = m.group(1);
        Preconditions.checkArgument((boolean)m.group(2).equals("END"), (String)"'%s' START after '%s' START", (Object[])new Object[]{endName, name});
        Preconditions.checkArgument((boolean)endName.equals(name), (String)"'%s' END after '%s' START", (Object[])new Object[]{endName, name});
        return new Section(name, input.substring(startIdx, m.end()), false);
    }

    protected static class Section {
        public final String name;
        public final String contents;
        public final boolean disabled;

        public Section(String name, String contents, boolean disabled) {
            this.name = name;
            this.contents = contents;
            this.disabled = disabled;
        }
    }
}

