/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.samskivert.util.ComparableArrayList;
import com.samskivert.util.StringUtil;
import com.threerings.presents.client.InvocationDecoder;
import com.threerings.presents.client.InvocationReceiver;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.server.InvocationSender;
import com.threerings.presents.tools.ImportSet;
import com.threerings.presents.tools.InvocationTask;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenReceiverTask
extends InvocationTask {
    protected File _asroot;
    protected static final String SENDER_TMPL = "com/threerings/presents/tools/sender.tmpl";
    protected static final String DECODER_TMPL = "com/threerings/presents/tools/decoder.tmpl";
    protected static final String AS_DECODER_TMPL = "com/threerings/presents/tools/decoder_as.tmpl";
    protected static final String AS_RECEIVER_TMPL = "com/threerings/presents/tools/receiver_as.tmpl";

    public void setAsroot(File asroot) {
        this._asroot = asroot;
    }

    @Override
    public void processClass(File source, Class<?> receiver) throws Exception {
        Method[] methdecls;
        System.out.println("Processing " + receiver.getName() + "...");
        String rname = receiver.getName();
        String rpackage = "";
        int didx = rname.lastIndexOf(".");
        if (didx != -1) {
            rpackage = rname.substring(0, didx);
            rname = rname.substring(didx + 1);
        }
        Preconditions.checkArgument((boolean)rname.endsWith("Receiver"), (String)"Cannot process '%s'. Receiver classes must be named SomethingReceiver.", (Object[])new Object[]{rname});
        ImportSet imports = new ImportSet();
        ComparableArrayList methods = new ComparableArrayList();
        for (Method m : methdecls = receiver.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers()) && !Modifier.isAbstract(m.getModifiers())) continue;
            methods.add((Object)new InvocationTask.ServiceMethod(this, m, imports));
        }
        methods.sort();
        imports.swapInnerClassesForParents();
        imports.translateClassArrays();
        imports.removeArrays();
        imports.removeGlobals();
        this.generateSender(source, rname, rpackage, (List<?>)methods, imports.toList().iterator());
        this.generateDecoder(receiver, source, rname, rpackage, (List<InvocationTask.ServiceMethod>)methods, imports.toList().iterator(), StringUtil.md5hex((String)(rpackage + "." + rname)));
    }

    protected void generateSender(File source, String rname, String rpackage, List<?> methods, Iterator<String> imports) throws Exception {
        String name = rname.replace("Receiver", "");
        String spackage = rpackage.replace(".client", ".server");
        ComparableArrayList implist = new ComparableArrayList();
        Iterators.addAll((Collection)implist, imports);
        GenReceiverTask.checkedAdd(implist, ClientObject.class.getName());
        GenReceiverTask.checkedAdd(implist, InvocationSender.class.getName());
        String dname = rname.replace("Receiver", "Decoder");
        GenReceiverTask.checkedAdd(implist, rpackage + "." + dname);
        GenReceiverTask.checkedAdd(implist, rpackage + "." + rname);
        implist.sort();
        String mpath = source.getPath();
        mpath = mpath.replace("Receiver", "Sender");
        mpath = GenReceiverTask.replacePath(mpath, "/client/", "/server/");
        this.writeTemplate(SENDER_TMPL, mpath, "name", name, "package", spackage, "methods", methods, "imports", implist);
    }

    protected void generateDecoder(Class<?> receiver, File source, String rname, String rpackage, List<InvocationTask.ServiceMethod> methods, Iterator<String> imports, String rcode) throws Exception {
        String name = rname.replace("Receiver", "");
        ComparableArrayList implist = new ComparableArrayList();
        Iterators.addAll((Collection)implist, imports);
        GenReceiverTask.checkedAdd(implist, InvocationDecoder.class.getName());
        implist.sort();
        String mpath = source.getPath();
        mpath = mpath.replace("Receiver", "Decoder");
        this.writeTemplate(DECODER_TMPL, mpath, "name", name, "receiver_code", rcode, "package", rpackage, "methods", methods, "imports", implist);
        if (this._asroot == null) {
            return;
        }
        String sppath = rpackage.replace('.', File.separatorChar);
        String aspath = this._asroot + File.separator + sppath + File.separator + name + "Decoder.as";
        this.writeTemplate(AS_DECODER_TMPL, aspath, "name", name, "receiver_code", rcode, "package", rpackage, "methods", methods, "imports", implist);
        aspath = this._asroot + File.separator + sppath + File.separator + rname + ".as";
        implist.remove((Object)InvocationDecoder.class.getName());
        GenReceiverTask.checkedAdd(implist, InvocationReceiver.class.getName());
        this.writeTemplate(AS_RECEIVER_TMPL, aspath, "name", name, "package", rpackage, "methods", methods, "imports", implist);
    }
}

