/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.samskivert.util.StringUtil;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.tools.ActionScriptUtils;
import com.threerings.presents.tools.GenTask;
import com.threerings.presents.tools.GeneratedSourceMerger;
import com.threerings.presents.tools.StreamableClassRequirements;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenActionScriptStreamableTask
extends GenTask {
    protected File _asroot;
    protected static final Pattern AS_PUBLIC_CLASS_DECL = Pattern.compile("^public class(.*)$", 8);
    protected static final Pattern AS_IMPORT = Pattern.compile("^(\\s*)import(\\s+)([^;]*);", 8);

    public void setAsroot(File asroot) {
        this._asroot = asroot;
    }

    @Override
    protected void processClass(File javaSource, Class<?> sclass) throws Exception {
        boolean isDObject;
        if (!Streamable.class.isAssignableFrom(sclass) || InvocationMarshaller.class.isAssignableFrom(sclass) || Modifier.isInterface(sclass.getModifiers()) || ActionScriptUtils.hasOmitAnnotation(sclass)) {
            this.log("Skipping " + sclass.getName(), 3);
            return;
        }
        this.log("Generating " + sclass.getName(), 3);
        File outputLocation = ActionScriptUtils.createActionScriptPath(this._asroot, sclass);
        String existing = null;
        if (outputLocation.exists()) {
            existing = Files.toString((File)outputLocation, (Charset)Charsets.UTF_8);
        }
        StreamableClassRequirements reqs = new StreamableClassRequirements(sclass);
        LinkedHashSet imports = Sets.newLinkedHashSet();
        imports.add(ObjectInputStream.class.getName());
        imports.add(ObjectOutputStream.class.getName());
        String extendsName = "";
        if (!sclass.getSuperclass().equals(Object.class)) {
            extendsName = ActionScriptUtils.addImportAndGetShortType(sclass.getSuperclass(), false, imports);
        }
        if (existing != null) {
            GenActionScriptStreamableTask.addExistingImports(existing, imports);
        }
        if (isDObject = DObject.class.isAssignableFrom(sclass)) {
            imports.add("org.osflash.signals.Signal");
        }
        LinkedHashSet implemented = Sets.newLinkedHashSet();
        for (Class<?> iface : sclass.getInterfaces()) {
            implemented.add(ActionScriptUtils.addImportAndGetShortType(iface, false, imports));
        }
        ArrayList pubFields = Lists.newArrayList();
        ArrayList protFields = Lists.newArrayList();
        for (Field f : reqs.streamedFields) {
            int mods = f.getModifiers();
            if (Modifier.isPublic(mods)) {
                pubFields.add(new ASField(f, imports));
                continue;
            }
            if (!Modifier.isProtected(mods)) continue;
            protFields.add(new ASField(f, imports));
        }
        String output = this.mergeTemplate("com/threerings/presents/tools/streamable_as.tmpl", "header", this._header, "package", sclass.getPackage().getName(), "classname", sclass.getSimpleName(), "imports", imports, "extends", extendsName, "implements", Joiner.on((String)", ").join((Iterable)implemented), "superclassStreamable", reqs.superclassStreamable, "pubFields", pubFields, "protFields", protFields, "dobject", isDObject);
        if (existing != null) {
            output = new GeneratedSourceMerger().merge(output, existing);
        }
        this.writeFile(outputLocation.getAbsolutePath(), output);
    }

    protected static void addExistingImports(String asFile, Set<String> imports) throws Exception {
        Matcher m = AS_PUBLIC_CLASS_DECL.matcher(asFile);
        int searchTo = asFile.length();
        if (m.find()) {
            searchTo = m.start();
        }
        m = AS_IMPORT.matcher(asFile.substring(0, searchTo));
        while (m.find()) {
            imports.add(m.group(3));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ASField {
        public final String name;
        public final String capitalName;
        public final String simpleType;
        public final String reader;
        public final String writer;
        public final String dobjectField;
        public boolean dset;
        public boolean array;
        public boolean oidList;

        public ASField(Field f, Set<String> imports) {
            this.name = f.getName();
            this.capitalName = StringUtil.capitalize((String)this.name);
            this.dobjectField = StringUtil.unStudlyName((String)this.name).toUpperCase();
            this.simpleType = ActionScriptUtils.addImportAndGetShortType(f.getType(), true, imports);
            if (List.class.isAssignableFrom(f.getType())) {
                imports.add("com.threerings.io.streamers.ArrayStreamer");
            } else if (Map.class.isAssignableFrom(f.getType())) {
                imports.add("com.threerings.io.streamers.MapStreamer");
            } else if (Set.class.isAssignableFrom(f.getType())) {
                imports.add("com.threerings.io.streamers.SetStreamer");
            } else if (DSet.class.isAssignableFrom(f.getType())) {
                this.dset = true;
                imports.add("com.threerings.presents.dobj.DSet_Entry");
            } else if (OidList.class.isAssignableFrom(f.getType())) {
                this.oidList = true;
            }
            this.array = f.getType().isArray();
            this.reader = ActionScriptUtils.toReadObject(f.getType());
            this.writer = ActionScriptUtils.toWriteObject(f.getType(), this.name);
        }
    }
}

