/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server.net;

import com.threerings.presents.Log;
import com.threerings.presents.net.AESAuthRequest;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.net.DownstreamMessage;
import com.threerings.presents.net.Message;
import com.threerings.presents.net.PublicKeyCredentials;
import com.threerings.presents.net.SecureRequest;
import com.threerings.presents.net.SecureResponse;
import com.threerings.presents.server.net.PresentsConnection;
import com.threerings.util.Name;
import java.io.IOException;
import java.security.PrivateKey;

public class AuthingConnection
extends PresentsConnection {
    protected AuthRequest _authreq;
    protected AuthResponse _authrsp;
    protected Name _authname;
    protected byte[] _serverSecret;
    protected int _clientSecureVersion;

    public AuthingConnection() {
        this.setMessageHandler(new PresentsConnection.MessageHandler(){

            public void handleMessage(Message msg) {
                if (AuthingConnection.this._serverSecret == null) {
                    try {
                        SecureRequest secreq = (SecureRequest)msg;
                        PrivateKey key = AuthingConnection.this._pcmgr.getPrivateKey();
                        if (key == null) {
                            AuthingConnection.this.safePostMessage(new SecureResponse("m.failed_to_secure"));
                        } else {
                            SecureResponse resp = new SecureResponse();
                            PublicKeyCredentials pkcreds = (PublicKeyCredentials)secreq.getCredentials();
                            AuthingConnection.this._clientSecureVersion = pkcreds.getSecureVersion();
                            AuthingConnection.this._serverSecret = resp.createSecret(pkcreds, key, 16);
                            AuthingConnection.this.safePostMessage(resp);
                        }
                        return;
                    }
                    catch (ClassCastException cce) {}
                } else {
                    try {
                        ((AESAuthRequest)msg).decrypt(AuthingConnection.this._serverSecret);
                    }
                    catch (ClassCastException cce) {
                        Log.log.warning((Object)"Received non-encrypted request during secure authentication process", new Object[]{"conn", AuthingConnection.this, "msg", msg});
                    }
                    catch (ClassNotFoundException cnfe) {
                        Log.log.warning((Object)"Failed to decrypt request during secure authentication process", new Object[]{"conn", AuthingConnection.this, "msg", msg, cnfe});
                        AuthingConnection.this.safePostMessage(new SecureResponse("m.failed_to_secure"));
                        return;
                    }
                    catch (IOException ioe) {
                        Log.log.warning((Object)"Failed to decrypt request during secure authentication process", new Object[]{"conn", AuthingConnection.this, "msg", msg, ioe});
                        AuthingConnection.this.safePostMessage(new SecureResponse("m.failed_to_secure"));
                        return;
                    }
                }
                try {
                    AuthingConnection.this._authreq = (AuthRequest)msg;
                }
                catch (ClassCastException cce) {
                    Log.log.warning((Object)"Received non-authreq message during authentication process", new Object[]{"conn", AuthingConnection.this, "msg", msg});
                }
                if (AuthingConnection.this._authreq != null) {
                    AuthingConnection.this._pcmgr.authenticateConnection(AuthingConnection.this);
                }
            }
        });
    }

    public AuthRequest getAuthRequest() {
        return this._authreq;
    }

    public AuthResponse getAuthResponse() {
        return this._authrsp;
    }

    public void setAuthResponse(AuthResponse authrsp) {
        this._authrsp = authrsp;
    }

    public Name getAuthName() {
        return this._authname;
    }

    public void setAuthName(Name authname) {
        this._authname = authname;
    }

    public String toString() {
        return "[mode=AUTHING, addr=" + this.getInetAddress() + "]";
    }

    protected final void safePostMessage(final DownstreamMessage msg) {
        this._pcmgr._omgr.postRunnable(new Runnable(){

            public void run() {
                AuthingConnection.this.postMessage(msg);
            }
        });
    }
}

