/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.common.collect.Maps;
import com.threerings.presents.client.TimeBaseService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.TimeBaseCodes;
import com.threerings.presents.data.TimeBaseMarshaller;
import com.threerings.presents.data.TimeBaseObject;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.InvocationException;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import java.util.HashMap;

public class TimeBaseProvider
implements InvocationProvider,
TimeBaseCodes {
    protected static HashMap<String, TimeBaseObject> _timeBases = Maps.newHashMap();
    protected static InvocationManager _invmgr;
    protected static RootDObjectManager _omgr;

    public static void init(InvocationManager invmgr, RootDObjectManager omgr) {
        _invmgr = invmgr;
        _omgr = omgr;
        invmgr.registerProvider(new TimeBaseProvider(), TimeBaseMarshaller.class, "presents");
    }

    public static TimeBaseObject createTimeBase(String timeBase) {
        TimeBaseObject object = _omgr.registerObject(new TimeBaseObject());
        _timeBases.put(timeBase, object);
        return object;
    }

    public static TimeBaseObject getTimeBase(String timeBase) {
        return _timeBases.get(timeBase);
    }

    public void getTimeOid(ClientObject source, String timeBase, TimeBaseService.GotTimeBaseListener listener) throws InvocationException {
        TimeBaseObject time = TimeBaseProvider.getTimeBase(timeBase);
        if (time == null) {
            throw new InvocationException("m.no_such_time_base");
        }
        listener.gotTimeOid(time.getOid());
    }
}

