/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.samskivert.util.Invoker;
import com.samskivert.util.StringUtil;
import com.threerings.presents.server.ReportManager;
import java.util.concurrent.Executor;

public class ReportingInvoker
extends Invoker {
    protected ReportManager.Reporter _defrep = new ReportManager.Reporter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendReport(StringBuilder buf, long now, long sinceLast, boolean reset) {
            buf.append("* " + ReportingInvoker.this.getName() + ":\n");
            int qsize = ReportingInvoker.this._queue.size();
            buf.append("- Queue size: ").append(qsize).append("\n");
            1 var8_6 = this;
            synchronized (var8_6) {
                Stats stats = ReportingInvoker.this.getStats(reset);
                buf.append("- Max queue size: ").append(stats.maxQueueSize).append("\n");
                buf.append("- Units executed: ").append(stats.unitsRun).append("\n");
                buf.append("- Total units executed: ").append(ReportingInvoker.this._totalUnitsRun);
                long runPerSec = (long)stats.unitsRun / Math.max(1L, sinceLast / 1000L);
                buf.append(" (").append(runPerSec).append("/s)\n");
                if (ReportingInvoker.this._currentUnit != null) {
                    String uname = StringUtil.safeToString((Object)ReportingInvoker.this._currentUnit);
                    buf.append("- Current unit: ").append(uname).append(" ");
                    buf.append(now - ReportingInvoker.this._currentUnitStart).append("ms\n");
                }
            }
        }
    };
    protected ReportManager.Reporter _profrep = new ReportManager.Reporter(){

        public void appendReport(StringBuilder buf, long now, long sinceLast, boolean reset) {
            buf.append("* " + ReportingInvoker.this.getName() + ":\n");
            for (Object key : ReportingInvoker.this._tracker.keySet()) {
                Invoker.UnitProfile profile = (Invoker.UnitProfile)ReportingInvoker.this._tracker.get(key);
                if (key instanceof Class) {
                    key = StringUtil.shortClassName((Class)((Class)key));
                }
                buf.append("  ").append(key).append(" ");
                buf.append(profile).append("\n");
                if (!reset) continue;
                profile.clear();
            }
        }
    };
    protected Stats _recent;
    protected Stats _current = this._recent = new Stats();
    protected int _totalUnitsRun;
    protected Object _currentUnit;
    protected long _currentUnitStart;

    public ReportingInvoker(String name, Executor receiver, ReportManager repmgr) {
        super(name, receiver);
        repmgr.registerReporter("", this._defrep);
        repmgr.registerReporter("profile", this._profrep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stats getStats(boolean snapshot) {
        ReportingInvoker reportingInvoker = this;
        synchronized (reportingInvoker) {
            if (snapshot) {
                this._recent = this._current;
                this._current = new Stats();
                this._current.maxQueueSize = this._queue.size();
            }
            return this._recent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void willInvokeUnit(Invoker.Unit unit, long start) {
        super.willInvokeUnit(unit, start);
        int queueSize = this._queue.size();
        ReportingInvoker reportingInvoker = this;
        synchronized (reportingInvoker) {
            if (queueSize > this._current.maxQueueSize) {
                this._current.maxQueueSize = queueSize;
            }
            ++this._current.unitsRun;
            ++this._totalUnitsRun;
            this._currentUnit = unit;
            this._currentUnitStart = start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void didInvokeUnit(Invoker.Unit unit, long start) {
        super.didInvokeUnit(unit, start);
        ReportingInvoker reportingInvoker = this;
        synchronized (reportingInvoker) {
            this._currentUnit = null;
            this._currentUnitStart = 0L;
        }
    }

    public static class Stats {
        public int unitsRun;
        public int maxQueueSize;
    }
}

