/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.inject.Inject;
import com.threerings.presents.Log;
import com.threerings.presents.server.PresentsServer;
import com.threerings.presents.server.ReportManager;
import com.threerings.presents.server.SignalReceiver;

public abstract class AbstractSignalHandler {
    @Inject(optional=true)
    protected SignalReceiver _usr2receiver;
    @Inject
    protected PresentsServer _server;
    @Inject
    protected ReportManager _repmgr;

    public boolean init() {
        return this.registerHandlers();
    }

    protected abstract boolean registerHandlers();

    protected void termReceived() {
        Log.log.info((Object)"Shutdown initiated by TERM signal.", new Object[0]);
        this._server.queueShutdown();
    }

    protected void intReceived() {
        Log.log.info((Object)"Shutdown initiated by INT signal.", new Object[0]);
        this._server.queueShutdown();
    }

    protected void hupReceived() {
        Log.log.info((Object)this._repmgr.generateReport(""), new Object[0]);
    }

    protected void usr2Received() {
        if (this._usr2receiver != null) {
            this._usr2receiver.received();
        }
    }
}

