/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.peer.server;

import com.google.inject.Inject;
import com.samskivert.util.ResultListenerList;
import com.threerings.presents.Log;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientObserver;
import com.threerings.presents.client.Communicator;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.SetListener;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.peer.data.ClientInfo;
import com.threerings.presents.peer.data.NodeObject;
import com.threerings.presents.peer.net.PeerBootstrapData;
import com.threerings.presents.peer.server.PeerManager;
import com.threerings.presents.peer.server.persist.NodeRecord;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.presents.server.net.PresentsConnectionManager;
import com.threerings.presents.server.net.ServerCommunicator;
import java.net.ConnectException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerNode
implements ClientObserver,
Subscriber<NodeObject> {
    public NodeObject nodeobj;
    protected NodeRecord _record;
    protected NodeObjectListener _listener;
    protected Client _client;
    protected long _lastConnectStamp;
    @Inject
    protected PeerManager _peermgr;
    @Inject
    protected PresentsDObjectMgr _omgr;
    @Inject
    protected PresentsConnectionManager _conmgr;
    protected static final long STALE_INTERVAL = 300000L;

    public void init(NodeRecord record) {
        this._record = record;
        this._client = new Client(null, this._omgr){

            protected void convertFromRemote(DObject target, DEvent event) {
                super.convertFromRemote(target, event);
                event.setTargetOid(target.getOid());
                event.eventId = PeerNode.this._omgr.getNextEventId(true);
            }

            protected Communicator createCommunicator() {
                return PeerNode.this.createCommunicator(this);
            }
        };
        this._client.addClientObserver(this);
    }

    public Client getClient() {
        return this._client;
    }

    public String getNodeName() {
        return this._record.nodeName;
    }

    public String getPublicHostName() {
        return this._record.publicHostName;
    }

    public String getInternalHostName() {
        return this._record.hostName;
    }

    public int getPort() {
        return this._record.port;
    }

    public void refresh(NodeRecord record) {
        if (!record.hostName.equals(this._record.hostName) && this._client.isActive()) {
            this._client.logoff(false);
        }
        this._record = record;
        if (this._client.isActive()) {
            return;
        }
        if (this._lastConnectStamp - this._record.lastUpdated.getTime() > 300000L) {
            Log.log.debug((Object)"Not reconnecting to stale client", new Object[]{"record", this._record, "lastTry", new Date(this._lastConnectStamp)});
            return;
        }
        this._client.setCredentials(this._peermgr.createCreds());
        this._client.setServer(this._record.hostName, new int[]{this._record.port});
        this._client.logon();
        this._lastConnectStamp = System.currentTimeMillis();
    }

    public void shutdown() {
        if (this._client.isActive()) {
            Log.log.info((Object)("Logging off of peer " + (Object)((Object)this._record) + "."), new Object[0]);
            this._client.logoff(false);
        }
    }

    @Override
    public void clientFailedToLogon(Client client, Exception cause) {
        if (cause instanceof ConnectException) {
            Log.log.info((Object)("Peer not online " + (Object)((Object)this._record) + ": " + cause.getMessage()), new Object[0]);
        } else {
            Log.log.warning((Object)("Peer logon attempt failed " + (Object)((Object)this._record) + ": " + cause), new Object[0]);
        }
    }

    @Override
    public void clientConnectionFailed(Client client, Exception cause) {
        Log.log.warning((Object)("Peer connection failed " + (Object)((Object)this._record) + ": " + cause), new Object[0]);
    }

    @Override
    public void clientWillLogon(Client client) {
    }

    @Override
    public void clientDidLogon(Client client) {
        Log.log.info((Object)("Connected to peer " + (Object)((Object)this._record) + "."), new Object[0]);
        PeerBootstrapData pdata = (PeerBootstrapData)client.getBootstrapData();
        client.getDObjectManager().subscribeToObject(pdata.nodeOid, this);
    }

    @Override
    public void clientObjectDidChange(Client client) {
    }

    @Override
    public boolean clientWillLogoff(Client client) {
        return true;
    }

    @Override
    public void clientDidLogoff(Client client) {
        if (this.nodeobj != null) {
            String nodeName = this.getNodeName();
            for (ClientInfo clinfo : this.nodeobj.clients) {
                this._peermgr.clientLoggedOff(nodeName, clinfo);
            }
            this.nodeobj.removeListener(this._listener);
        }
        this._peermgr.disconnectedFromPeer(this);
        this._listener = null;
        this.nodeobj = null;
    }

    @Override
    public void clientDidClear(Client client) {
    }

    @Override
    public void objectAvailable(NodeObject object) {
        this.nodeobj = object;
        this._listener = this.createListener();
        this.nodeobj.addListener(this._listener);
        this._peermgr.connectedToPeer(this);
        String nodeName = this.getNodeName();
        for (ClientInfo clinfo : this.nodeobj.clients) {
            this._peermgr.clientLoggedOn(nodeName, clinfo);
        }
    }

    @Override
    public void requestFailed(int oid, ObjectAccessException cause) {
        Log.log.warning((Object)"Failed to subscribe to peer's node object", new Object[]{"peer", this._record, "cause", cause});
    }

    protected static boolean hasPriority(String nodeName1, String nodeName2) {
        return nodeName1.compareTo(nodeName2) < 0;
    }

    protected Communicator createCommunicator(Client client) {
        return new ServerCommunicator(client, this._conmgr, this._omgr);
    }

    protected NodeObjectListener createListener() {
        return new NodeObjectListener();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NodeObjectListener
    implements AttributeChangeListener,
    SetListener<DSet.Entry> {
        protected NodeObjectListener() {
        }

        @Override
        public void attributeChanged(AttributeChangedEvent event) {
            String name = event.getName();
            if (name.equals("acquiringLock")) {
                NodeObject.Lock lock = PeerNode.this.nodeobj.acquiringLock;
                PeerManager.LockHandler handler = PeerNode.this._peermgr.getLockHandler(lock);
                if (handler == null) {
                    if (PeerNode.this._peermgr.getNodeObject().locks.contains(lock)) {
                        Log.log.warning((Object)"Peer trying to acquire lock owned by this node", new Object[]{"lock", lock, "node", PeerNode.this._record.nodeName});
                        return;
                    }
                    PeerNode.this._peermgr.createLockHandler(PeerNode.this, lock, true);
                    return;
                }
                if (PeerNode.hasPriority(handler.getNodeName(), PeerNode.this._record.nodeName)) {
                    return;
                }
                ResultListenerList<String> olisteners = handler.listeners;
                handler.cancel();
                handler = PeerNode.this._peermgr.createLockHandler(PeerNode.this, lock, true);
                handler.listeners = olisteners;
            } else if (name.equals("releasingLock")) {
                NodeObject.Lock lock = PeerNode.this.nodeobj.releasingLock;
                PeerManager.LockHandler handler = PeerNode.this._peermgr.getLockHandler(lock);
                if (handler == null) {
                    PeerNode.this._peermgr.createLockHandler(PeerNode.this, lock, false);
                } else {
                    Log.log.warning((Object)"Received request to release resolving lock", new Object[]{"node", PeerNode.this._record.nodeName, "handler", handler});
                }
            } else if (name.equals("cacheData")) {
                PeerNode.this._peermgr.changedCacheData(PeerNode.this.nodeobj.cacheData.cache, PeerNode.this.nodeobj.cacheData.data);
            }
        }

        @Override
        public void entryAdded(EntryAddedEvent<DSet.Entry> event) {
            String name = event.getName();
            if ("clients".equals(name)) {
                PeerNode.this._peermgr.clientLoggedOn(PeerNode.this.getNodeName(), (ClientInfo)event.getEntry());
            }
        }

        @Override
        public void entryUpdated(EntryUpdatedEvent<DSet.Entry> event) {
        }

        @Override
        public void entryRemoved(EntryRemovedEvent<DSet.Entry> event) {
            String name = event.getName();
            if ("clients".equals(name)) {
                PeerNode.this._peermgr.clientLoggedOff(PeerNode.this.getNodeName(), (ClientInfo)event.getOldEntry());
            }
        }
    }
}

