/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.net;

import com.threerings.presents.net.Credentials;
import com.threerings.presents.util.SecureUtil;
import java.security.PrivateKey;
import java.security.PublicKey;

public class PublicKeyCredentials
extends Credentials {
    protected byte[] _encodedSecret;
    protected byte[] _salt;
    protected int _secureVersion;
    protected transient byte[] _secret;

    public PublicKeyCredentials() {
    }

    public PublicKeyCredentials(PublicKey key) {
        this._secret = SecureUtil.createRandomKey(16);
        this._salt = SecureUtil.createRandomKey(4);
        this._encodedSecret = SecureUtil.encryptBytes(key, this._secret, this._salt);
        this._secureVersion = 1;
    }

    public int getSecureVersion() {
        return this._secureVersion;
    }

    public byte[] getSecret() {
        return this._secret;
    }

    public byte[] getSecret(PrivateKey key) {
        if (this._secret == null) {
            this._secret = SecureUtil.decryptBytes(key, this._encodedSecret, this._salt);
        }
        return this._secret;
    }

    public String getDatagramSecret() {
        return new String(this._encodedSecret);
    }
}

