/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.samskivert.util.StringUtil;
import com.threerings.presents.Log;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.SetListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryUpdatedEvent<T extends DSet.Entry>
extends EntryEvent<T> {
    protected T _entry;
    protected transient T _oldEntry = UNSET_OLD_ENTRY;

    public EntryUpdatedEvent(int targetOid, String name, T entry) {
        super(targetOid, name);
        this._entry = entry;
    }

    @Override
    public Comparable<?> getKey() {
        return this._entry.getKey();
    }

    @Override
    public T getEntry() {
        return this._entry;
    }

    @Override
    public T getOldEntry() {
        return this._oldEntry;
    }

    @Override
    public boolean alreadyApplied() {
        return this._oldEntry != UNSET_OLD_ENTRY;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        if (!this.alreadyApplied()) {
            DSet set = target.getSet(this._name);
            this._oldEntry = set.update(this._entry);
            if (this._oldEntry == null) {
                Log.log.warning((Object)"No matching entry to update", new Object[]{"entry", this, "set", set});
                return false;
            }
        }
        return true;
    }

    @Override
    protected void notifyListener(Object listener) {
        if (listener instanceof SetListener) {
            SetListener setlist = (SetListener)listener;
            setlist.entryUpdated(this);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("ELUPD:");
        super.toString(buf);
        buf.append(", entry=");
        StringUtil.toString((StringBuilder)buf, this._entry);
    }

    protected EntryUpdatedEvent setOldEntry(T oldEntry) {
        this._oldEntry = oldEntry;
        return this;
    }
}

