/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.threerings.presents.Log;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.SetListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryRemovedEvent<T extends DSet.Entry>
extends EntryEvent<T> {
    protected Comparable<?> _key;
    protected transient T _oldEntry = UNSET_OLD_ENTRY;

    public EntryRemovedEvent(int targetOid, String name, Comparable<?> key) {
        super(targetOid, name);
        this._key = key;
    }

    @Override
    public Comparable<?> getKey() {
        return this._key;
    }

    @Override
    public T getEntry() {
        return null;
    }

    @Override
    public T getOldEntry() {
        return this._oldEntry;
    }

    @Override
    public boolean alreadyApplied() {
        return this._oldEntry != UNSET_OLD_ENTRY;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        if (!this.alreadyApplied()) {
            DSet set = target.getSet(this._name);
            this._oldEntry = set.removeKey(this._key);
            if (this._oldEntry == null) {
                Log.log.warning((Object)"No matching entry to remove", new Object[]{"key", this._key, "set", set});
                return false;
            }
        }
        return true;
    }

    @Override
    protected void notifyListener(Object listener) {
        if (listener instanceof SetListener) {
            SetListener setlist = (SetListener)listener;
            setlist.entryRemoved(this);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("ELREM:");
        super.toString(buf);
        buf.append(", key=").append(this._key);
    }

    protected EntryRemovedEvent setOldEntry(T oldEntry) {
        this._oldEntry = oldEntry;
        return this;
    }
}

