/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.samskivert.util.StringUtil;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.SetListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryAddedEvent<T extends DSet.Entry>
extends EntryEvent<T> {
    protected T _entry;
    protected transient boolean _alreadyApplied;

    public EntryAddedEvent(int targetOid, String name, T entry) {
        super(targetOid, name);
        this._entry = entry;
    }

    @Override
    public Comparable<?> getKey() {
        return this._entry.getKey();
    }

    @Override
    public T getEntry() {
        return this._entry;
    }

    @Override
    public T getOldEntry() {
        return null;
    }

    @Override
    public boolean alreadyApplied() {
        return this._alreadyApplied;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        return this._alreadyApplied || target.getSet(this._name).add(this._entry);
    }

    @Override
    protected void notifyListener(Object listener) {
        if (listener instanceof SetListener) {
            SetListener setlist = (SetListener)listener;
            setlist.entryAdded(this);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("ELADD:");
        super.toString(buf);
        buf.append(", entry=");
        StringUtil.toString((StringBuilder)buf, this._entry);
    }

    protected EntryAddedEvent setAlreadyApplied(boolean alreadyApplied) {
        this._alreadyApplied = alreadyApplied;
        return this;
    }
}

