/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.io.Streamable;
import com.threerings.presents.Log;
import com.threerings.presents.dobj.AccessController;
import com.threerings.presents.dobj.Accessor;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.CompoundEvent;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.ElementUpdatedEvent;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.EventListener;
import com.threerings.presents.dobj.MessageEvent;
import com.threerings.presents.dobj.ObjectAddedEvent;
import com.threerings.presents.dobj.ObjectDestroyedEvent;
import com.threerings.presents.dobj.ObjectRemovedEvent;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.dobj.ProxySubscriber;
import com.threerings.presents.dobj.ReleaseLockEvent;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.net.Transport;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DObject
implements Streamable {
    protected int _oid;
    protected transient Accessor[] _accessors;
    protected transient DObjectManager _omgr;
    protected transient AccessController _controller;
    protected transient Object[] _locks;
    protected transient Object[] _subs;
    protected transient Object[] _listeners;
    protected transient int _scount;
    protected transient CompoundEvent _tevent;
    protected transient int _tcount;
    protected transient boolean _tcancelled;
    protected transient boolean _deathWish = false;
    protected transient Object[] _locattrs = NO_ATTRS;
    protected static Map<Class<?>, Accessor[]> _atable = Maps.newHashMap();
    protected static final Object[] NO_ATTRS = new Object[0];

    public DObject() {
        this._accessors = _atable.get(this.getClass());
        if (this._accessors == null) {
            this._accessors = this.createAccessors();
            Arrays.sort(this._accessors);
            _atable.put(this.getClass(), this._accessors);
        }
    }

    public int getOid() {
        return this._oid;
    }

    public DObjectManager getManager() {
        return this._omgr;
    }

    public void addSubscriber(Subscriber<?> sub) {
        Object[] subs = ListUtil.testAndAddRef((Object[])this._subs, sub);
        if (subs != null) {
            this._subs = subs;
            ++this._scount;
        } else {
            Log.log.warning((Object)"Refusing subscriber that's already in the list", new Object[]{"dobj", this.which(), "subscriber", sub, new Exception()});
        }
    }

    public void removeSubscriber(Subscriber<?> sub) {
        if (ListUtil.clearRef((Object[])this._subs, sub) != null && --this._scount == 0 && this._omgr != null) {
            this._omgr.removedLastSubscriber(this, this._deathWish);
        }
    }

    public void setDestroyOnLastSubscriberRemoved(boolean deathWish) {
        this._deathWish = deathWish;
    }

    public void addListener(ChangeListener listener) {
        this.addListener(listener, false);
    }

    public void addListener(ChangeListener listener, boolean weak) {
        int idx = this.getListenerIndex(listener);
        if (idx == -1) {
            this._listeners = ListUtil.add((Object[])this._listeners, (Object)(weak ? new WeakReference<ChangeListener>(listener) : listener));
            return;
        }
        boolean oweak = this._listeners[idx] instanceof WeakReference;
        if (weak == oweak) {
            Log.log.warning((Object)"Refusing repeat listener registration", new Object[]{"dobj", this.which(), "list", listener, new Exception()});
        } else {
            Log.log.warning((Object)"Updating listener registered under different strength.", new Object[]{"dobj", this.which(), "list", listener, "oweak", oweak, "nweak", weak, new Exception()});
            this._listeners[idx] = weak ? new WeakReference<ChangeListener>(listener) : listener;
        }
    }

    public void removeListener(ChangeListener listener) {
        int idx = this.getListenerIndex(listener);
        if (idx != -1) {
            this._listeners[idx] = null;
        }
    }

    public void setAccessController(AccessController controller) {
        this._controller = controller;
    }

    public AccessController getAccessController() {
        return this._controller;
    }

    public final <T extends DSet.Entry> DSet<T> getSet(String setName) {
        DSet casted = (DSet)this.getAccessor(setName).get(this);
        return casted;
    }

    public <T extends DSet.Entry> void addToSet(String setName, T entry) {
        this.requestEntryAdd(setName, this.getSet(setName), entry);
    }

    public void updateSet(String setName, DSet.Entry entry) {
        this.requestEntryUpdate(setName, this.getSet(setName), entry);
    }

    public void removeFromSet(String setName, Comparable<?> key) {
        this.requestEntryRemove(setName, this.getSet(setName), key);
    }

    public boolean acquireLock(String name) {
        Object[] list = ListUtil.testAndAdd((Object[])this._locks, (Object)name);
        if (list == null) {
            return false;
        }
        this._locks = list;
        return true;
    }

    public void releaseLock(String name) {
        this.postEvent(new ReleaseLockEvent(this._oid, name));
    }

    protected void clearLock(String name) {
        if (ListUtil.clear((Object[])this._locks, (Object)name) == null) {
            Log.log.info((Object)"Unable to clear non-existent lock", new Object[]{"lock", name, "dobj", this});
        }
    }

    public void destroy() {
        if (this._oid == 0) {
            Log.log.warning((Object)"Denying request to destroy an uninitialized object!", new Object[]{new Exception()});
            return;
        }
        this.postEvent(new ObjectDestroyedEvent(this._oid));
    }

    public boolean checkPermissions(Subscriber<?> sub) {
        if (this._controller != null) {
            return this._controller.allowSubscribe(this, sub);
        }
        return true;
    }

    public boolean checkPermissions(DEvent event) {
        if (this._controller != null) {
            return this._controller.allowDispatch(this, event);
        }
        return true;
    }

    public void notifyListeners(DEvent event) {
        if (this._listeners == null) {
            return;
        }
        for (Object listener : this._listeners) {
            if (listener == null) continue;
            if (listener instanceof WeakReference && (listener = ((WeakReference)listener).get()) == null) {
                this._listeners[ii] = null;
                continue;
            }
            try {
                event.notifyListener(listener);
                if (!(listener instanceof EventListener)) continue;
                ((EventListener)listener).eventReceived(event);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Listener choked during notification", new Object[]{"list", listener, "event", event, e});
            }
        }
    }

    public void notifyProxies(DEvent event) {
        if (this._subs == null || event.isPrivate()) {
            return;
        }
        for (Object sub : this._subs) {
            try {
                if (sub == null || !(sub instanceof ProxySubscriber)) continue;
                ((ProxySubscriber)sub).eventReceived(event);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Proxy choked during notification", new Object[]{"sub", sub, "event", event, e});
            }
        }
    }

    public void changeAttribute(String name, Object value) {
        Accessor acc = this.getAccessor(name);
        this.requestAttributeChange(name, value, acc.get(this));
        acc.set(this, value);
    }

    public void setAttribute(String name, Object value) {
        this.getAccessor(name).set(this, value);
    }

    public Object getAttribute(String name) {
        return this.getAccessor(name).get(this);
    }

    public void postMessage(String name, Object ... args) {
        this.postMessage(Transport.DEFAULT, name, args);
    }

    public void postMessage(Transport transport, String name, Object ... args) {
        this.postEvent(new MessageEvent(this._oid, name, args).setTransport(transport));
    }

    public void postEvent(DEvent event) {
        if (this._tevent != null) {
            this._tevent.postEvent(event);
        } else if (this._omgr != null) {
            this._omgr.postEvent(event);
        } else {
            Log.log.info((Object)"Dropping event for non- or no longer managed object", new Object[]{"oid", this.getOid(), "class", this.getClass().getName(), "event", event});
        }
    }

    public final boolean isActive() {
        return this._omgr != null;
    }

    public void setManager(DObjectManager omgr) {
        this._omgr = omgr;
    }

    public void setOid(int oid) {
        this._oid = oid;
    }

    public <T> void setLocal(Class<T> key, T attr) {
        int ll = this._locattrs.length;
        for (int ii = 0; ii < ll; ++ii) {
            if (!key.isInstance(this._locattrs[ii])) continue;
            if (attr != null) {
                throw new IllegalStateException("Attribute already exists that matches the supplied key [key=" + key + ", have=" + this._locattrs[ii].getClass());
            }
            this._locattrs = ArrayUtil.splice((Object[])this._locattrs, (int)ii, (int)1);
            return;
        }
        if (attr == null) {
            return;
        }
        this._locattrs = ArrayUtil.append((Object[])this._locattrs, attr);
    }

    public <T> T getLocal(Class<T> key) {
        for (Object attr : this._locattrs) {
            if (!key.isInstance(attr)) continue;
            return key.cast(attr);
        }
        return null;
    }

    public List<Object> getLocals() {
        return ImmutableList.copyOf((Object[])this._locattrs);
    }

    public String which() {
        StringBuilder buf = new StringBuilder();
        this.which(buf);
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.append("]").toString();
    }

    protected void which(StringBuilder buf) {
        buf.append(StringUtil.shortClassName((Object)this));
        buf.append(":").append(this._oid);
    }

    protected void toString(StringBuilder buf) {
        StringUtil.fieldsToString((StringBuilder)buf, (Object)this, (String)"\n");
        if (buf.length() > 0) {
            buf.insert(0, "\n");
        }
        buf.insert(0, this._oid);
        buf.insert(0, "[oid=");
    }

    public void startTransaction() {
        if (this._tevent != null) {
            ++this._tcount;
        } else {
            this._tevent = new CompoundEvent(this, this._omgr);
        }
    }

    public void commitTransaction() {
        if (this._tevent == null) {
            String errmsg = "Cannot commit: not involved in a transaction [dobj=" + this + "]";
            throw new IllegalStateException(errmsg);
        }
        if (this._tcount > 0) {
            --this._tcount;
        } else if (this._tcancelled) {
            this._tevent.cancel();
        } else {
            this._tevent.commit();
        }
    }

    public boolean inTransaction() {
        return this._tevent != null;
    }

    public void cancelTransaction() {
        if (this._tevent == null) {
            String errmsg = "Cannot cancel: not involved in a transaction [dobj=" + this + "]";
            throw new IllegalStateException(errmsg);
        }
        if (this._tcount > 0) {
            this._tcancelled = true;
            --this._tcount;
        } else {
            this._tevent.cancel();
        }
    }

    protected void clearTransaction() {
        if (this._tcount != 0) {
            Log.log.warning((Object)"Transaction cleared with non-zero nesting count", new Object[]{"dobj", this});
            this._tcount = 0;
        }
        this._tevent = null;
        this._tcancelled = false;
    }

    protected void requestAttributeChange(String name, Object value, Object oldValue) {
        this.requestAttributeChange(name, value, oldValue, Transport.DEFAULT);
    }

    protected void requestAttributeChange(String name, Object value, Object oldValue, Transport transport) {
        this.postEvent(new AttributeChangedEvent(this._oid, name, value).setOldValue(oldValue).setTransport(transport));
    }

    protected void requestElementUpdate(String name, int index, Object value, Object oldValue) {
        this.requestElementUpdate(name, index, value, oldValue, Transport.DEFAULT);
    }

    protected void requestElementUpdate(String name, int index, Object value, Object oldValue, Transport transport) {
        this.postEvent(new ElementUpdatedEvent(this._oid, name, value, index).setOldValue(oldValue).setTransport(transport));
    }

    protected void requestOidAdd(String name, OidList list, int oid) {
        boolean applyImmediately = this.isAuthoritative();
        if (applyImmediately) {
            list.add(oid);
        }
        this.postEvent(new ObjectAddedEvent(this._oid, name, oid).setAlreadyApplied(applyImmediately));
    }

    protected void requestOidRemove(String name, OidList list, int oid) {
        boolean applyImmediately = this.isAuthoritative();
        if (applyImmediately) {
            list.remove(oid);
        }
        this.postEvent(new ObjectRemovedEvent(this._oid, name, oid).setAlreadyApplied(applyImmediately));
    }

    @Deprecated
    protected void requestOidAdd(String name, int oid) {
        this.postEvent(new ObjectAddedEvent(this._oid, name, oid));
    }

    @Deprecated
    protected void requestOidRemove(String name, int oid) {
        this.postEvent(new ObjectRemovedEvent(this._oid, name, oid));
    }

    protected <T extends DSet.Entry> void requestEntryAdd(String name, DSet<T> set, T entry) {
        boolean applyImmediately = this.isAuthoritative();
        if (applyImmediately) {
            set.add(entry);
        }
        this.postEvent(new EntryAddedEvent<T>(this._oid, name, entry).setAlreadyApplied(applyImmediately));
    }

    protected <T extends DSet.Entry> void requestEntryRemove(String name, DSet<T> set, Comparable<?> key) {
        Object oldEntry = null;
        if (this.isAuthoritative() && (oldEntry = (Object)set.removeKey(key)) == null) {
            Log.log.warning((Object)"Requested to remove non-element", new Object[]{"set", name, "key", key, new Exception()});
        }
        this.postEvent(new EntryRemovedEvent<Object>(this._oid, name, key).setOldEntry(oldEntry));
    }

    protected <T extends DSet.Entry> void requestEntryUpdate(String name, DSet<T> set, T entry) {
        this.requestEntryUpdate(name, set, entry, Transport.DEFAULT);
    }

    protected <T extends DSet.Entry> void requestEntryUpdate(String name, DSet<T> set, T entry, Transport transport) {
        Object oldEntry = null;
        if (this.isAuthoritative() && (oldEntry = (Object)set.update(entry)) == null) {
            Log.log.warning((Object)"Set update had no old entry", new Object[]{"name", name, "entry", entry, new Exception()});
        }
        this.postEvent(new EntryUpdatedEvent<Object>(this._oid, name, entry).setOldEntry(oldEntry).setTransport(transport));
    }

    protected boolean isAuthoritative() {
        return this._omgr != null && this._omgr.isManager(this);
    }

    protected final Accessor getAccessor(String name) {
        int low = 0;
        int high = this._accessors.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Accessor midVal = this._accessors[mid];
            int cmp = midVal.name.compareTo(name);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        throw new IllegalArgumentException("No such field " + this.getClass().getName() + "." + name);
    }

    protected Accessor[] createAccessors() {
        Field[] fields = this.getClass().getFields();
        ArrayList accs = Lists.newArrayListWithExpectedSize((int)(fields.length / 2));
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            accs.add(new Accessor.ByField(field));
        }
        return accs.toArray(new Accessor[accs.size()]);
    }

    protected int getListenerIndex(ChangeListener listener) {
        if (this._listeners == null) {
            return -1;
        }
        int ll = this._listeners.length;
        for (int ii = 0; ii < ll; ++ii) {
            Object olistener = this._listeners[ii];
            if (olistener != listener && (!(olistener instanceof WeakReference) || ((WeakReference)olistener).get() != listener)) continue;
            return ii;
        }
        return -1;
    }
}

