/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.client;

import com.samskivert.util.LoopingThread;
import com.samskivert.util.Queue;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Throttle;
import com.threerings.io.ByteBufferInputStream;
import com.threerings.io.ByteBufferOutputStream;
import com.threerings.io.FramedInputStream;
import com.threerings.io.FramingOutputStream;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.UnreliableObjectInputStream;
import com.threerings.io.UnreliableObjectOutputStream;
import com.threerings.presents.Log;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientObjectInputStream;
import com.threerings.presents.client.ClientObserver;
import com.threerings.presents.client.Communicator;
import com.threerings.presents.client.ObserverOps;
import com.threerings.presents.client.SessionObserver;
import com.threerings.presents.net.AESAuthRequest;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.net.AuthResponseData;
import com.threerings.presents.net.DownstreamMessage;
import com.threerings.presents.net.LogoffRequest;
import com.threerings.presents.net.PingRequest;
import com.threerings.presents.net.PublicKeyCredentials;
import com.threerings.presents.net.SecureRequest;
import com.threerings.presents.net.SecureResponse;
import com.threerings.presents.net.TransmitDatagramsRequest;
import com.threerings.presents.net.Transport;
import com.threerings.presents.net.UpstreamMessage;
import com.threerings.presents.util.DatagramSequencer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public class BlockingCommunicator
extends Communicator {
    protected Reader _reader;
    protected Writer _writer;
    protected DatagramReader _datagramReader;
    protected DatagramWriter _datagramWriter;
    protected SocketChannel _channel;
    protected Queue<UpstreamMessage> _msgq = new Queue();
    protected Selector _selector;
    protected DatagramChannel _datagramChannel;
    protected Queue<UpstreamMessage> _dataq = new Queue();
    protected Exception _logonError;
    protected FramingOutputStream _fout;
    protected ObjectOutputStream _oout;
    protected FramedInputStream _fin;
    protected ObjectInputStream _oin;
    protected ByteBufferOutputStream _bout;
    protected UnreliableObjectOutputStream _uout;
    protected MessageDigest _digest;
    protected byte[] _secret;
    protected ByteBuffer _buf = ByteBuffer.allocateDirect(1450);
    protected DatagramSequencer _sequencer;
    protected ClassLoader _loader;
    protected static final int DATAGRAM_ATTEMPTS_PER_PORT = 10;
    protected static final long DATAGRAM_RESPONSE_WAIT = 1000L;

    public BlockingCommunicator(Client client) {
        super(client);
    }

    public void logon() {
        if (this._reader != null) {
            throw new RuntimeException("Communicator already started.");
        }
        this._reader = new Reader();
        this._reader.start();
    }

    public synchronized void logoff() {
        if (this._channel == null) {
            return;
        }
        this.postMessage(new LogoffRequest());
        if (this._reader != null) {
            this._reader.shutdown();
        }
        if (this._writer != null) {
            this._writer.shutdown();
        }
        if (this._datagramWriter != null) {
            this._datagramWriter.shutdown();
        }
        if (this._datagramReader != null) {
            this._datagramReader.shutdown();
        }
    }

    public void gotBootstrap() {
        if (this._client.getDatagramPorts().length > 0) {
            this._datagramReader = new DatagramReader();
            this._datagramReader.start();
        }
    }

    public void postMessage(UpstreamMessage msg) {
        if (!msg.getTransport().isReliable() && this._datagramWriter != null) {
            msg.noteActualTransport(Transport.UNRELIABLE_UNORDERED);
            this._dataq.append((Object)msg);
        } else {
            msg.noteActualTransport(Transport.RELIABLE_ORDERED);
            this._msgq.append((Object)msg);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
        if (this._oin != null) {
            this._oin.setClassLoader(loader);
        }
    }

    public synchronized long getLastWrite() {
        return this._lastWrite;
    }

    public boolean getTransmitDatagrams() {
        return this._datagramWriter != null;
    }

    protected synchronized void logonSucceeded(AuthResponseData data) {
        super.logonSucceeded(data);
        if (this._writer != null) {
            throw new RuntimeException("Writer already started!?");
        }
        this._writer = new Writer();
        this._writer.start();
    }

    protected synchronized void connectionFailed(final IOException ioe) {
        if (this._channel == null) {
            return;
        }
        Log.log.info((Object)"Connection failed", new Object[]{ioe});
        this.notifyClientObservers(new ObserverOps.Client(this._client){

            protected void notify(ClientObserver obs) {
                obs.clientConnectionFailed(this._client, ioe);
            }
        });
        this.logoff();
    }

    protected synchronized void connectionClosed() {
        if (this._channel == null) {
            return;
        }
        Log.log.debug((Object)"Connection closed.", new Object[0]);
        this.logoff();
    }

    protected synchronized void readerDidExit() {
        this._reader = null;
        if (this._writer == null) {
            this.closeChannel();
            this.clientCleanup(this._logonError);
        }
        Log.log.debug((Object)"Reader thread exited.", new Object[0]);
    }

    protected synchronized void writerDidExit() {
        this._writer = null;
        Log.log.debug((Object)"Writer thread exited.", new Object[0]);
        this.notifyClientObservers(new ObserverOps.Session(this._client){

            protected void notify(SessionObserver obs) {
                obs.clientDidLogoff(this._client);
            }
        });
        this.closeChannel();
        if (this._reader == null) {
            this.clientCleanup(this._logonError);
        }
    }

    protected void closeChannel() {
        if (this._channel != null) {
            Log.log.debug((Object)"Closing socket channel.", new Object[0]);
            try {
                this._channel.close();
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Error closing failed socket: " + ioe), new Object[0]);
            }
            this._channel = null;
            this._oin = null;
            this._oout = null;
        }
    }

    protected synchronized void datagramReaderDidExit() {
        this._datagramReader = null;
        if (this._datagramWriter == null) {
            this.closeDatagramChannel();
        }
        Log.log.debug((Object)"Datagram reader thread exited.", new Object[0]);
    }

    protected synchronized void datagramWriterDidExit() {
        this._datagramWriter = null;
        if (this._datagramReader == null) {
            this.closeDatagramChannel();
        }
        Log.log.debug((Object)"Datagram writer thread exited.", new Object[0]);
    }

    protected void closeDatagramChannel() {
        if (this._selector != null) {
            try {
                this._selector.close();
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Error closing selector: " + ioe), new Object[0]);
            }
            this._selector = null;
        }
        if (this._datagramChannel != null) {
            Log.log.debug((Object)"Closing datagram socket channel.", new Object[0]);
            try {
                this._datagramChannel.close();
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Error closing datagram socket: " + ioe), new Object[0]);
            }
            this._datagramChannel = null;
            this._uout = null;
            this._sequencer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(UpstreamMessage msg) throws IOException {
        if (this.debugLogMessages()) {
            Log.log.info((Object)("SEND " + msg), new Object[0]);
        }
        this._oout.writeObject(msg);
        this._oout.flush();
        try {
            int wrote;
            ByteBuffer buffer = this._fout.frameAndReturnBuffer();
            if (buffer.limit() > 4096) {
                String txt = StringUtil.truncate((String)String.valueOf(msg), (int)80, (String)"...");
                Log.log.info((Object)"Whoa, writin' a big one", new Object[]{"msg", txt, "size", buffer.limit()});
            }
            if ((wrote = this.writeMessage(buffer)) != buffer.limit()) {
                Log.log.warning((Object)"Aiya! Couldn't write entire message", new Object[]{"msg", msg, "size", buffer.limit(), "wrote", wrote});
            } else {
                this._client.getMessageTracker().messageSent(false, wrote, msg);
            }
        }
        finally {
            this._fout.resetFrame();
        }
        this.updateWriteStamp();
    }

    protected int writeMessage(ByteBuffer buf) throws IOException {
        return this._channel.write(buf);
    }

    protected void sendDatagram(UpstreamMessage msg) throws IOException {
        this._bout.reset();
        this._uout.writeInt(this._client.getConnectionId());
        this._uout.writeLong(0L);
        this._sequencer.writeDatagram(msg);
        ByteBuffer buf = this._bout.flip();
        int size = buf.remaining();
        if (size > 1450) {
            Log.log.warning((Object)"Dropping oversized datagram", new Object[]{"size", size, "msg", msg});
            return;
        }
        buf.position(12);
        this._digest.update(buf);
        byte[] hash = this._digest.digest(this._secret);
        buf.position(4);
        buf.put(hash, 0, 8).rewind();
        this.writeDatagram(buf);
        this._client.getMessageTracker().messageSent(true, size, msg);
    }

    protected int writeDatagram(ByteBuffer buf) throws IOException {
        return this._datagramChannel.write(buf);
    }

    protected DownstreamMessage receiveMessage() throws IOException {
        while (!this.readFrame()) {
        }
        if (this._oin == null) {
            throw new InterruptedIOException();
        }
        try {
            int size = this._fin.available();
            DownstreamMessage msg = (DownstreamMessage)this._oin.readObject();
            if (this.debugLogMessages()) {
                Log.log.info((Object)("RECEIVE " + msg), new Object[0]);
            }
            this._client.getMessageTracker().messageReceived(false, size, msg, 0);
            return msg;
        }
        catch (ClassNotFoundException cnfe) {
            throw (IOException)new IOException("Unable to decode incoming message.").initCause(cnfe);
        }
    }

    protected boolean readFrame() throws IOException {
        return this._fin.readFrame(this._channel);
    }

    protected DownstreamMessage receiveDatagram() throws IOException {
        this._buf.clear();
        int size = this.readDatagram(this._buf);
        if (size <= 0) {
            throw new IOException("No datagram available to read.");
        }
        this._buf.flip();
        try {
            DownstreamMessage msg = (DownstreamMessage)this._sequencer.readDatagram();
            if (this._client != null) {
                this._client.getMessageTracker().messageReceived(true, size, msg, msg == null ? 0 : this._sequencer.getMissedCount());
            }
            if (msg == null) {
                return null;
            }
            if (this.debugLogMessages()) {
                Log.log.info((Object)("DATAGRAM " + msg), new Object[0]);
            }
            return msg;
        }
        catch (ClassNotFoundException cnfe) {
            throw (IOException)new IOException("Unable to decode incoming datagram.").initCause(cnfe);
        }
    }

    protected int readDatagram(ByteBuffer buf) throws IOException {
        return this._datagramChannel.read(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openChannel(InetAddress host) throws IOException {
        int port = this._client.getPorts()[0];
        Log.log.info((Object)"Connecting", new Object[]{"host", host, "port", port});
        BlockingCommunicator blockingCommunicator = this;
        synchronized (blockingCommunicator) {
            this._channel = SocketChannel.open(new InetSocketAddress(host, port));
        }
    }

    protected boolean debugLogMessages() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void throttleOutgoingMessage() {
        Throttle throttle;
        Throttle throttle2 = throttle = this._client.getOutgoingMessageThrottle();
        synchronized (throttle2) {
            while (throttle.throttleOp()) {
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected static class TerminationMessage
    extends UpstreamMessage {
        protected TerminationMessage() {
        }
    }

    protected class DatagramWriter
    extends LoopingThread {
        public DatagramWriter() {
            super("BlockingCommunicator_DatagramWriter");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void iterate() {
            Throttle throttle;
            UpstreamMessage msg = (UpstreamMessage)BlockingCommunicator.this._dataq.get();
            if (msg instanceof TerminationMessage) {
                return;
            }
            Throttle throttle2 = throttle = BlockingCommunicator.this._client.getOutgoingMessageThrottle();
            synchronized (throttle2) {
                if (throttle.throttleOp()) {
                    return;
                }
            }
            try {
                BlockingCommunicator.this.sendDatagram(msg);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Error sending datagram", new Object[]{"error", ioe});
            }
        }

        protected void handleIterateFailure(Exception e) {
            Log.log.warning((Object)"Uncaught exception in datagram writer thread.", new Object[]{e});
        }

        protected void didShutdown() {
            BlockingCommunicator.this.datagramWriterDidExit();
        }

        protected void kick() {
            BlockingCommunicator.this._dataq.append((Object)new TerminationMessage());
        }
    }

    protected class DatagramReader
    extends LoopingThread {
        public DatagramReader() {
            super("BlockingCommunicator_DatagramReader");
        }

        protected void willStart() {
            try {
                this.connect();
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failed to open datagram channel", new Object[]{"error", ioe});
                this.shutdown();
            }
        }

        protected void connect() throws IOException {
            BlockingCommunicator.this._selector = Selector.open();
            BlockingCommunicator.this._datagramChannel = DatagramChannel.open();
            BlockingCommunicator.this._datagramChannel.socket().setTrafficClass(16);
            BlockingCommunicator.this._datagramChannel.configureBlocking(false);
            BlockingCommunicator.this._datagramChannel.register(BlockingCommunicator.this._selector, 1, null);
            try {
                BlockingCommunicator.this._digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                Log.log.warning((Object)"Missing MD5 algorithm.", new Object[0]);
                this.shutdown();
                return;
            }
            BlockingCommunicator.this._secret = BlockingCommunicator.this._client.getCredentials().getDatagramSecret().getBytes("UTF-8");
            BlockingCommunicator.this._bout = new ByteBufferOutputStream();
            BlockingCommunicator.this._uout = new UnreliableObjectOutputStream(BlockingCommunicator.this._bout);
            ByteBufferInputStream bin = new ByteBufferInputStream(BlockingCommunicator.this._buf);
            UnreliableObjectInputStream uin = new UnreliableObjectInputStream(bin);
            uin.setClassLoader(BlockingCommunicator.this._loader);
            BlockingCommunicator.this._sequencer = new DatagramSequencer(uin, BlockingCommunicator.this._uout);
            int cport = -1;
            for (int port : BlockingCommunicator.this._client.getDatagramPorts()) {
                boolean connected = this.connect(port);
                if (!this.isRunning()) {
                    return;
                }
                if (!connected) continue;
                cport = port;
                break;
            }
            BlockingCommunicator.this._selector.close();
            BlockingCommunicator.this._selector = null;
            BlockingCommunicator.this._datagramChannel.configureBlocking(true);
            if (cport > 0) {
                Log.log.info((Object)"Datagram connection established", new Object[]{"port", cport});
                BlockingCommunicator.this.postMessage(new TransmitDatagramsRequest());
                BlockingCommunicator.this._datagramWriter = new DatagramWriter();
                BlockingCommunicator.this._datagramWriter.start();
            } else {
                Log.log.info((Object)"Failed to establish datagram connection.", new Object[0]);
                this.shutdown();
            }
        }

        protected boolean connect(int port) throws IOException {
            BlockingCommunicator.this._datagramChannel.connect(new InetSocketAddress(BlockingCommunicator.this._client.getHostname(), port));
            for (int ii = 0; ii < 10; ++ii) {
                BlockingCommunicator.this.sendDatagram(new PingRequest(Transport.UNRELIABLE_UNORDERED));
                int resp = BlockingCommunicator.this._selector.select(1000L);
                if (!this.isRunning()) {
                    return false;
                }
                if (resp <= 0) continue;
                BlockingCommunicator.this.receiveDatagram();
                return true;
            }
            BlockingCommunicator.this._datagramChannel.disconnect();
            return false;
        }

        protected void iterate() {
            DownstreamMessage msg = null;
            try {
                msg = BlockingCommunicator.this.receiveDatagram();
                if (msg != null) {
                    BlockingCommunicator.this.processMessage(msg);
                }
            }
            catch (AsynchronousCloseException ace) {
                Log.log.debug((Object)"Datagram reader thread woken up in time to die.", new Object[0]);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Error receiving datagram", new Object[]{ioe});
            }
            catch (Exception e) {
                Log.log.warning((Object)"Error processing message", new Object[]{"msg", msg, e});
            }
        }

        protected void handleIterateFailure(Exception e) {
            Log.log.warning((Object)"Uncaught exception in datagram reader thread.", new Object[]{e});
        }

        protected void didShutdown() {
            BlockingCommunicator.this.datagramReaderDidExit();
        }

        protected void kick() {
            if (BlockingCommunicator.this._selector != null) {
                BlockingCommunicator.this._selector.wakeup();
            }
        }
    }

    protected class Writer
    extends LoopingThread {
        public Writer() {
            super("BlockingCommunicator_Writer");
        }

        public synchronized void shutdown() {
            BlockingCommunicator.this.postMessage(new TerminationMessage());
        }

        protected void iterate() {
            UpstreamMessage msg = (UpstreamMessage)BlockingCommunicator.this._msgq.get();
            if (msg instanceof TerminationMessage) {
                super.shutdown();
                return;
            }
            BlockingCommunicator.this.throttleOutgoingMessage();
            try {
                BlockingCommunicator.this.sendMessage(msg);
            }
            catch (IOException ioe) {
                BlockingCommunicator.this.connectionFailed(ioe);
                super.shutdown();
            }
        }

        protected void handleIterateFailure(Exception e) {
            Log.log.warning((Object)"Uncaught exception it writer thread.", new Object[]{e});
        }

        protected void didShutdown() {
            BlockingCommunicator.this.writerDidExit();
        }
    }

    protected class Reader
    extends LoopingThread {
        public Reader() {
            super("BlockingCommunicator_Reader");
        }

        protected void willStart() {
            try {
                this.connect();
                PublicKey key = BlockingCommunicator.this._client.getPublicKey();
                AuthResponse response = null;
                if (key != null) {
                    PublicKeyCredentials pkcreds = new PublicKeyCredentials(key);
                    BlockingCommunicator.this.sendMessage(new SecureRequest(pkcreds, BlockingCommunicator.this._client.getVersion()));
                    Log.log.debug((Object)"Waiting for secure response.", new Object[0]);
                    response = (AuthResponse)BlockingCommunicator.this.receiveMessage();
                    if (response instanceof SecureResponse) {
                        AuthRequest areq = AESAuthRequest.createAuthRequest(BlockingCommunicator.this._client.getCredentials(), BlockingCommunicator.this._client.getVersion(), BlockingCommunicator.this._client.getBootGroups(), BlockingCommunicator.this._client.requireSecureAuth(), pkcreds, (SecureResponse)response);
                        BlockingCommunicator.this.sendMessage(areq);
                        BlockingCommunicator.this._client.setSecret(areq.getSecret());
                        Log.log.debug((Object)"Waiting for auth response.", new Object[0]);
                        response = (AuthResponse)BlockingCommunicator.this.receiveMessage();
                    }
                } else {
                    BlockingCommunicator.this.sendMessage(AESAuthRequest.createAuthRequest(BlockingCommunicator.this._client.getCredentials(), BlockingCommunicator.this._client.getVersion(), BlockingCommunicator.this._client.getBootGroups(), BlockingCommunicator.this._client.requireSecureAuth()));
                    Log.log.debug((Object)"Waiting for auth response.", new Object[0]);
                    response = (AuthResponse)BlockingCommunicator.this.receiveMessage();
                }
                BlockingCommunicator.this.gotAuthResponse(response);
            }
            catch (Exception e) {
                Log.log.debug((Object)("Logon failed: " + e), new Object[0]);
                BlockingCommunicator.this._logonError = e;
                this.shutdown();
            }
        }

        protected void connect() throws IOException {
            if (BlockingCommunicator.this._channel != null) {
                throw new IOException("Already connected.");
            }
            InetAddress host = InetAddress.getByName(BlockingCommunicator.this._client.getHostname());
            BlockingCommunicator.this.openChannel(host);
            BlockingCommunicator.this._channel.configureBlocking(true);
            BlockingCommunicator.this._fin = new FramedInputStream();
            BlockingCommunicator.this._fout = new FramingOutputStream();
            BlockingCommunicator.this._oin = new ClientObjectInputStream(BlockingCommunicator.this._client, BlockingCommunicator.this._fin);
            BlockingCommunicator.this._oin.setClassLoader(BlockingCommunicator.this._loader);
            BlockingCommunicator.this._oout = new ObjectOutputStream(BlockingCommunicator.this._fout);
        }

        protected void iterate() {
            DownstreamMessage msg = null;
            try {
                msg = BlockingCommunicator.this.receiveMessage();
                BlockingCommunicator.this.processMessage(msg);
            }
            catch (InterruptedIOException iioe) {
                Log.log.debug((Object)"Reader thread woken up in time to die.", new Object[0]);
            }
            catch (EOFException eofe) {
                BlockingCommunicator.this.connectionClosed();
                this.shutdown();
            }
            catch (IOException ioe) {
                BlockingCommunicator.this.connectionFailed(ioe);
                this.shutdown();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Error processing message", new Object[]{"msg", msg, e});
            }
        }

        protected void handleIterateFailure(Exception e) {
            Log.log.warning((Object)"Uncaught exception it reader thread.", new Object[]{e});
        }

        protected void didShutdown() {
            BlockingCommunicator.this.readerDidExit();
        }

        protected void kick() {
        }
    }
}

