/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.nio;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.Lifecycle;
import com.samskivert.util.Tuple;
import com.threerings.NaryaLog;
import com.threerings.nio.conman.Connection;
import com.threerings.nio.conman.ConnectionManager;
import com.threerings.nio.conman.ServerSocketChannelAcceptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.SocketChannel;

@Singleton
public class PolicyServer
extends ConnectionManager {
    protected ServerSocketChannelAcceptor _acceptor;
    protected byte[] _policy;
    protected static final int MASTER_PORT = 843;

    public static void main(String[] args) {
        int port = 843;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        PolicyServer server = null;
        try {
            server = new PolicyServer(new Lifecycle());
        }
        catch (IOException e) {
            System.err.println("Failed to create policy server!");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        server.init(port);
    }

    @Inject
    public PolicyServer(Lifecycle cycle) throws IOException {
        super(cycle, 30000L);
    }

    public void init(int socketPolicyPort) {
        this._acceptor = new ServerSocketChannelAcceptor(null, new int[]{socketPolicyPort}, this);
        StringBuilder policy = new StringBuilder("<cross-domain-policy>\n");
        if (socketPolicyPort == 843) {
            policy.append("  <site-control permitted-cross-domain-policies=\"master-only\"/>\n");
        }
        policy.append("  <allow-access-from domain=\"*\" to-ports=\"*\"/>\n");
        policy.append("</cross-domain-policy>\n");
        try {
            this._policy = policy.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding missing; this vm is broken", e);
        }
        this.start();
    }

    protected void willStart() {
        super.willStart();
        if (!this._acceptor.bind()) {
            NaryaLog.log.warning((Object)"Policy server failed to bind!", new Object[0]);
            this.shutdown();
        }
    }

    protected void didShutdown() {
        super.didShutdown();
        this._acceptor.shutdown();
    }

    protected void handleAcceptedSocket(SocketChannel channel) {
        Connection conn = new Connection(){

            public int handleEvent(long when) {
                return 0;
            }
        };
        this.handleAcceptedSocket(channel, conn);
        this._outq.append((Object)Tuple.newTuple((Object)conn, (Object)this._policy));
        this.postAsyncClose(conn);
    }
}

