/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class FramedInputStream
extends InputStream {
    protected ByteBuffer _buffer = ByteBuffer.allocate(32);
    protected int _length = -1;
    protected int _have = 0;
    protected static final int HEADER_SIZE = 4;
    protected static final int INITIAL_BUFFER_CAPACITY = 32;
    protected static final int MAX_BUFFER_CAPACITY = 524288;

    public boolean readFrame(ReadableByteChannel source) throws IOException {
        if (this._buffer.limit() == this._length) {
            this._buffer.limit(this._have);
            this._buffer.position(this._length);
            this._buffer.compact();
            this._have -= this._length;
            this._length = this.decodeLength();
        }
        if (this.checkForCompleteFrame()) {
            return true;
        }
        do {
            int got;
            if ((got = source.read(this._buffer)) == -1) {
                throw new EOFException();
            }
            this._have += got;
            if (this._length == -1) {
                this._length = this.decodeLength();
            }
            if (this._buffer.remaining() > 0 || this._length > 0 && this._have >= this._length) break;
            ByteBuffer newbuf = ByteBuffer.allocate(this._buffer.capacity() << 1);
            newbuf.put((ByteBuffer)this._buffer.flip());
            this._buffer = newbuf;
        } while (this._buffer.capacity() < 524288);
        return this.checkForCompleteFrame();
    }

    protected final int decodeLength() {
        if (this._have < 4) {
            return -1;
        }
        this._buffer.rewind();
        int length = (this._buffer.get() & 0xFF) << 24;
        length += (this._buffer.get() & 0xFF) << 16;
        length += (this._buffer.get() & 0xFF) << 8;
        this._buffer.position(this._have);
        return length += this._buffer.get() & 0xFF;
    }

    protected final boolean checkForCompleteFrame() {
        if (this._length == -1 || this._have < this._length) {
            return false;
        }
        this._buffer.position(4);
        this._buffer.limit(this._length);
        return true;
    }

    public int read() {
        return this._buffer.remaining() > 0 ? this._buffer.get() & 0xFF : -1;
    }

    public int read(byte[] b, int off, int len) {
        if (len == 0) {
            return 0;
        }
        if ((len = Math.min(len, this._buffer.remaining())) == 0) {
            return -1;
        }
        this._buffer.get(b, off, len);
        return len;
    }

    public long skip(long n) {
        throw new UnsupportedOperationException();
    }

    public int available() {
        return this._buffer.remaining();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) {
    }

    public void reset() {
        this._buffer.position(4);
    }
}

