/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import com.google.common.collect.Maps;
import com.threerings.NaryaLog;
import com.threerings.io.BasicStreamers;
import com.threerings.io.Intern;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.io.Streamer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.util.Date;
import java.util.Map;

public abstract class FieldMarshaller {
    protected final String _type;
    protected static Map<Class<?>, FieldMarshaller> _marshallers;
    protected static FieldMarshaller _internMarshaller;
    protected static final Class<?>[] READER_ARGS;
    protected static final Class<?>[] WRITER_ARGS;

    public FieldMarshaller() {
        this(null);
    }

    public FieldMarshaller(String type) {
        this._type = type;
    }

    public abstract void readField(Field var1, Object var2, ObjectInputStream var3) throws Exception;

    public abstract void writeField(Field var1, Object var2, ObjectOutputStream var3) throws Exception;

    public String toString() {
        if (this._type != null) {
            return "FieldMarshaller " + this._type;
        }
        return super.toString();
    }

    public static FieldMarshaller getFieldMarshaller(Field field) {
        Class<?> ftype;
        if (_marshallers == null) {
            FieldMarshaller.createMarshallers();
        }
        if (FieldMarshaller.useFieldAccessors()) {
            Method reader = null;
            Method writer = null;
            try {
                reader = field.getDeclaringClass().getMethod(FieldMarshaller.getReaderMethodName(field.getName()), READER_ARGS);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            try {
                writer = field.getDeclaringClass().getMethod(FieldMarshaller.getWriterMethodName(field.getName()), WRITER_ARGS);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            if (reader != null && writer != null) {
                return new MethodFieldMarshaller(reader, writer);
            }
            if (reader == null && writer != null || writer == null && reader != null) {
                NaryaLog.log.warning((Object)"Class contains one but not both custom field reader and writer", new Object[]{"class", field.getDeclaringClass().getName(), "field", field.getName(), "reader", reader, "writer", writer});
            }
        }
        if ((ftype = field.getType()) == String.class && field.isAnnotationPresent(Intern.class)) {
            return _internMarshaller;
        }
        FieldMarshaller fm = _marshallers.get(ftype);
        if (fm == null) {
            Class<?> collClass = Streamer.getCollectionClass(ftype);
            if (collClass != null && !collClass.equals(ftype)) {
                NaryaLog.log.warning((Object)"Specific field types are discouraged for Iterables/Collections and Maps. The implementation type may not be recreated on the other side.", new Object[]{"class", field.getDeclaringClass(), "field", field.getName(), "type", ftype, "shouldBe", collClass});
                fm = _marshallers.get(collClass);
            }
            if (fm == null && (ftype.isInterface() || Streamer.isStreamable(ftype))) {
                fm = _marshallers.get(Streamable.class);
            }
        }
        return fm;
    }

    public static final String getReaderMethodName(String field) {
        return "readField_" + field;
    }

    public static final String getWriterMethodName(String field) {
        return "writeField_" + field;
    }

    protected static boolean useFieldAccessors() {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            return false;
        }
        catch (SecurityException se) {
            return true;
        }
    }

    protected static void createMarshallers() {
        _marshallers = Maps.newHashMap();
        FieldMarshaller gmarsh = new FieldMarshaller("Generic"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.set(target, in.readObject());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeObject(field.get(source));
            }
        };
        _marshallers.put(Streamable.class, gmarsh);
        _marshallers.put(Object.class, gmarsh);
        _marshallers.put(Boolean.TYPE, new FieldMarshaller("boolean"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setBoolean(target, in.readBoolean());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeBoolean(field.getBoolean(source));
            }
        });
        _marshallers.put(Byte.TYPE, new FieldMarshaller("byte"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setByte(target, in.readByte());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeByte(field.getByte(source));
            }
        });
        _marshallers.put(Character.TYPE, new FieldMarshaller("char"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setChar(target, in.readChar());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeChar(field.getChar(source));
            }
        });
        _marshallers.put(Short.TYPE, new FieldMarshaller("short"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setShort(target, in.readShort());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeShort(field.getShort(source));
            }
        });
        _marshallers.put(Integer.TYPE, new FieldMarshaller("int"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setInt(target, in.readInt());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeInt(field.getInt(source));
            }
        });
        _marshallers.put(Long.TYPE, new FieldMarshaller("long"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setLong(target, in.readLong());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeLong(field.getLong(source));
            }
        });
        _marshallers.put(Float.TYPE, new FieldMarshaller("float"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setFloat(target, in.readFloat());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeFloat(field.getFloat(source));
            }
        });
        _marshallers.put(Double.TYPE, new FieldMarshaller("double"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setDouble(target, in.readDouble());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeDouble(field.getDouble(source));
            }
        });
        _marshallers.put(Date.class, new FieldMarshaller("Date"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.set(target, new Date(in.readLong()));
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeLong(((Date)field.get(source)).getTime());
            }
        });
        for (Map.Entry<Class<?>, Streamer> entry : BasicStreamers.BSTREAMERS.entrySet()) {
            _marshallers.put(entry.getKey(), new StreamerMarshaller(entry.getValue()));
        }
        _internMarshaller = new FieldMarshaller("intern"){

            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.set(target, in.readIntern());
            }

            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeIntern((String)field.get(source));
            }
        };
    }

    static {
        READER_ARGS = new Class[]{ObjectInputStream.class};
        WRITER_ARGS = new Class[]{ObjectOutputStream.class};
    }

    protected static class MethodFieldMarshaller
    extends FieldMarshaller {
        protected Method _reader;
        protected Method _writer;

        public MethodFieldMarshaller(Method reader, Method writer) {
            this._reader = reader;
            this._writer = writer;
        }

        public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
            this._reader.invoke(target, in);
        }

        public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
            this._writer.invoke(source, out);
        }
    }

    protected static class StreamerMarshaller
    extends FieldMarshaller {
        protected Streamer _streamer;

        public StreamerMarshaller(Streamer streamer) {
            this._streamer = streamer;
        }

        public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
            if (in.readBoolean()) {
                Object value = this._streamer.createObject(in);
                this._streamer.readObject(value, in, true);
                field.set(target, value);
            } else {
                field.set(target, null);
            }
        }

        public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
            Object value = field.get(source);
            if (value == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this._streamer.writeObject(value, out, true);
            }
        }

        public String toString() {
            return "StreamerMarshaller:" + this._streamer.toString();
        }
    }
}

