/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public class ByteBufferInputStream
extends InputStream {
    protected ByteBuffer _buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this._buffer;
    }

    public int read() {
        try {
            return this._buffer.get() & 0xFF;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if ((length = Math.min(length, this._buffer.remaining())) <= 0) {
            return -1;
        }
        this._buffer.get(b, offset, length);
        return length;
    }

    public long skip(long n) throws IOException {
        n = Math.min(n, (long)this._buffer.remaining());
        this._buffer.position((int)((long)this._buffer.position() + n));
        return n;
    }

    public int available() {
        return this._buffer.remaining();
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readLimit) {
        this._buffer.mark();
    }

    public void reset() throws IOException {
        try {
            this._buffer.reset();
        }
        catch (InvalidMarkException e) {
            throw new IOException("No mark set.");
        }
    }
}

